/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.scalars;

import graphql.language.ScalarTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.idl.ScalarInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.graphql.api.SlingGraphQLException;
import org.apache.sling.graphql.api.SlingScalarConverter;
import org.apache.sling.graphql.core.osgi.ServiceReferenceObjectTuple;
import org.apache.sling.graphql.core.scalars.SlingCoercingWrapper;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={SlingScalarsProvider.class}, property={"service.description=Apache Sling Scripting GraphQL Scalars Provider", "service.vendor=The Apache Software Foundation"})
public class SlingScalarsProvider {
    private final Map<String, TreeSet<ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>>> scalars = new HashMap<String, TreeSet<ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=SlingScalarConverter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindSlingScalarConverter(ServiceReference<SlingScalarConverter<Object, Object>> serviceReference, SlingScalarConverter<Object, Object> scalarConverter) {
        String name = (String)serviceReference.getProperty("name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Map<String, TreeSet<ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>>> map = this.scalars;
            synchronized (map) {
                TreeSet set = this.scalars.computeIfAbsent(name, key -> new TreeSet());
                set.add(new ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>(serviceReference, scalarConverter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindSlingScalarConverter(ServiceReference<SlingScalarConverter<Object, Object>> serviceReference) {
        String name = (String)serviceReference.getProperty("name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Map<String, TreeSet<ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>>> map = this.scalars;
            synchronized (map) {
                TreeSet<ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>> set = this.scalars.get(name);
                if (set != null) {
                    Optional<ServiceReferenceObjectTuple> tupleToRemove = set.stream().filter(tuple -> serviceReference.equals(tuple.getServiceReference())).findFirst();
                    tupleToRemove.ifPresent(set::remove);
                }
            }
        }
    }

    private GraphQLScalarType getScalar(String name) {
        if (ScalarInfo.isGraphqlSpecifiedScalar((String)name)) {
            return null;
        }
        TreeSet<ServiceReferenceObjectTuple<SlingScalarConverter<Object, Object>>> set = this.scalars.get(name);
        if (set == null || set.isEmpty()) {
            throw new SlingGraphQLException("SlingScalarConverter with name '" + name + "' not found");
        }
        SlingScalarConverter<Object, Object> converter = set.last().getServiceObject();
        return GraphQLScalarType.newScalar().name(name).description(converter.toString()).coercing((Coercing)new SlingCoercingWrapper(converter)).build();
    }

    public Iterable<GraphQLScalarType> getCustomScalars(Map<String, ScalarTypeDefinition> schemaScalars) {
        return schemaScalars.keySet().stream().map(this::getScalar).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

