/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.content;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionHandler;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.ImportOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageExistsException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.InstallationScope;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.taskoption.ImportOptionsPackageTaskOption;

public class ContentHandler
implements ExtensionHandler {
    public static final String PACKAGEREGISTRY_HOME = "packageregistry.home";
    private static final String REPOSITORY_HOME = "repository.home";
    private static final String REGISTRY_FOLDER = "packageregistry";

    private static ExecutionPlanBuilder buildExecutionPlan(Collection<Artifact> artifacts, Set<PackageId> satisfiedPackages, LauncherPrepareContext prepareContext, File registryHome, boolean useStrictMode) throws Exception {
        ArrayList<File> packageReferences = new ArrayList<File>();
        for (Artifact a : artifacts) {
            URL file = prepareContext.getArtifactFile(a.getId());
            File tmp = IOUtils.getFileFromURL((URL)file, (boolean)true, null);
            if (tmp == null || tmp.length() <= 0L) continue;
            packageReferences.add(tmp);
        }
        if (!registryHome.exists()) {
            registryHome.mkdirs();
        }
        FSPackageRegistry registry = new FSPackageRegistry(registryHome, InstallationScope.UNSCOPED, new AbstractPackageRegistry.SecurityConfig(null, null), true);
        ExecutionPlanBuilder builder = registry.createExecutionPlan();
        builder.with(satisfiedPackages);
        for (File pkgFile : packageReferences) {
            try {
                PackageId pid = registry.registerExternal(pkgFile, false);
                ImportOptions importOptions = new ImportOptions();
                importOptions.setStrict(useStrictMode);
                ImportOptionsPackageTaskOption options = new ImportOptionsPackageTaskOption(importOptions);
                builder.addTask().with(pid).withOptions(options).with(PackageTask.Type.EXTRACT);
            }
            catch (PackageExistsException packageExistsException) {}
        }
        builder.validate();
        satisfiedPackages.addAll(builder.preview());
        return builder;
    }

    public boolean handle(ExtensionContext context, Extension extension) throws Exception {
        File registryHome = this.getRegistryHomeDir(context);
        if (extension.getType() == ExtensionType.ARTIFACTS && extension.getName().equals("content-packages")) {
            boolean useStrictMode = Boolean.getBoolean(this.getClass().getPackageName() + ".useStrictMode");
            TreeMap<Integer, Collection> orderedArtifacts = new TreeMap<Integer, Collection>();
            for (Artifact a : extension.getArtifacts()) {
                int order = a.getMetadata().get("start-order") != null ? a.getStartOrder() : Integer.MAX_VALUE;
                orderedArtifacts.computeIfAbsent(order, id -> new ArrayList()).add(a);
            }
            ArrayList<String> executionPlans = new ArrayList<String>();
            HashSet<PackageId> satisfiedPackages = new HashSet<PackageId>();
            for (Collection artifacts : orderedArtifacts.values()) {
                ExecutionPlanBuilder builder = ContentHandler.buildExecutionPlan(artifacts, satisfiedPackages, (LauncherPrepareContext)context, registryHome, useStrictMode);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                builder.save(baos);
                executionPlans.add(baos.toString(StandardCharsets.UTF_8));
            }
            Configuration initcfg = new Configuration("org.apache.sling.jcr.packageinit.impl.ExecutionPlanRepoInitializer");
            initcfg.getProperties().put("executionplans", executionPlans.toArray(new String[executionPlans.size()]));
            initcfg.getProperties().put("statusfilepath", registryHome.getAbsolutePath() + File.separator + "executedplans.file");
            context.addConfiguration(initcfg.getPid(), null, initcfg.getProperties());
            Configuration registrycfg = new Configuration("org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry");
            registrycfg.getProperties().put("homePath", registryHome.getPath());
            context.addConfiguration(registrycfg.getPid(), null, registrycfg.getProperties());
            return true;
        }
        return false;
    }

    private File getRegistryHomeDir(ExtensionContext context) {
        File registryHome;
        String registryPath = System.getProperty(PACKAGEREGISTRY_HOME);
        if (registryPath != null) {
            registryHome = Paths.get(registryPath, new String[0]).toFile();
        } else {
            String repoHome = (String)context.getFrameworkProperties().get(REPOSITORY_HOME);
            if (repoHome == null) {
                throw new IllegalStateException("Neither registry.home set nor repository.home configured.");
            }
            registryHome = Paths.get(repoHome, REGISTRY_FOLDER).toFile();
        }
        if (!registryHome.exists()) {
            registryHome.mkdirs();
        }
        if (!registryHome.isDirectory()) {
            throw new IllegalStateException("Registry home points to file - must be directory: " + registryHome);
        }
        return registryHome;
    }
}

