/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Aggregate;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.SerializationType;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXFormatter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.DocViewFormat;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.Serializer;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;

public class DocViewSerializer
implements Serializer {
    private final AggregateImpl aggregate;

    public DocViewSerializer(Aggregate aggregate) {
        this.aggregate = (AggregateImpl)aggregate;
    }

    @Override
    public void writeContent(OutputStream out) throws IOException, RepositoryException {
        try (FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create(out, new DocViewFormat().getXmlOutputFormat());){
            DocViewSAXFormatter fmt = new DocViewSAXFormatter(this.aggregate, writer);
            this.aggregate.walk(fmt);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public SerializationType getType() {
        return SerializationType.XML_DOCVIEW;
    }
}

