/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.impl.DistributionQueueUtils;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueue;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueUtils;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveResourceQueue
extends ResourceQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ActiveResourceQueue(ResourceResolverFactory resolverFactory, String serviceName, String queueName, String rootPath) {
        super(resolverFactory, serviceName, queueName, rootPath);
    }

    @Override
    @NotNull
    public DistributionQueueStatus getStatus() {
        DistributionQueueStatus distributionQueueStatus;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            int count = ResourceQueueUtils.getResourceCount(queueRoot);
            DistributionQueueEntry head = ResourceQueueUtils.getHead(queueRoot);
            DistributionQueueItem firstItem = null != head ? head.getItem() : null;
            DistributionQueueItemStatus firstItemStatus = null != head ? head.getStatus() : null;
            this.log.debug("Queue has {} items, with following status for the head: {}", (Object)count, (Object)firstItemStatus);
            distributionQueueStatus = new DistributionQueueStatus(count, DistributionQueueUtils.calculateState(firstItem, firstItemStatus));
        }
        catch (LoginException | PersistenceException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
        }
        DistributionUtils.safelyLogout(resourceResolver);
        return distributionQueueStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordProcessingAttempt(@NotNull DistributionQueueEntry entry) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceName);
            Resource queueRoot = ResourceQueueUtils.getRootResource(resourceResolver, this.queueRootPath);
            Resource queueItemResource = ResourceQueueUtils.getResourceById(queueRoot, entry.getId());
            ResourceQueueUtils.incrementProcessingAttemptForQueueItem(queueItemResource);
            resourceResolver.commit();
            this.log.debug("incremented processing-attempt for queue entry with id: {}", (Object)entry.getId());
        }
        catch (Exception e) {
            try {
                this.log.warn("Couldn't increment processing-attempt for queue entry with id: {}", (Object)entry.getId());
            }
            catch (Throwable throwable) {
                DistributionUtils.safelyLogout(resourceResolver);
                throw throwable;
            }
            DistributionUtils.safelyLogout(resourceResolver);
        }
        DistributionUtils.safelyLogout(resourceResolver);
    }
}

