/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.util.Optional;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.OAuthTokenAccess;
import org.apache.sling.auth.oauth_client.OAuthTokenResponse;
import org.apache.sling.auth.oauth_client.impl.OAuthToken;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenRefresher;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenStore;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.TokenState;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TokenAccessImpl
implements OAuthTokenAccess {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OAuthTokenStore tokenStore;
    private OAuthTokenRefresher tokenRefresher;

    @Activate
    public TokenAccessImpl(@Reference OAuthTokenStore tokenStore, @Reference OAuthTokenRefresher tokenRefresher) {
        this.tokenStore = tokenStore;
        this.tokenRefresher = tokenRefresher;
    }

    @Override
    public OAuthTokenResponse getAccessToken(ClientConnection connection, SlingHttpServletRequest request, String redirectPath) {
        OAuthToken refreshToken;
        ResourceResolver resolver = request.getResourceResolver();
        OAuthToken token = this.tokenStore.getAccessToken(connection, resolver);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Accessing token for connection {} and user {}", (Object)connection.name(), (Object)request.getUserPrincipal());
        }
        if (token.getState() == TokenState.VALID) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Returning valid access token for connection {} and user {}", (Object)connection.name(), (Object)request.getUserPrincipal());
            }
            return new OAuthTokenResponse(Optional.of(token.getValue()), connection, request, redirectPath);
        }
        if (token.getState() == TokenState.EXPIRED && (refreshToken = this.tokenStore.getRefreshToken(connection, resolver)).getState() == TokenState.VALID) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Refreshing expired access token for connection {} and user {}", (Object)connection.name(), (Object)request.getUserPrincipal());
            }
            OAuthTokens newTokens = this.tokenRefresher.refreshTokens(connection, refreshToken.getValue());
            this.tokenStore.persistTokens(connection, resolver, newTokens);
            return new OAuthTokenResponse(Optional.of(newTokens.accessToken()), connection, request, redirectPath);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No valid access token found for connection {} and user {}", (Object)connection.name(), (Object)request.getUserPrincipal());
        }
        return new OAuthTokenResponse(Optional.empty(), connection, request, redirectPath);
    }

    @Override
    public OAuthTokenResponse clearAccessToken(ClientConnection connection, SlingHttpServletRequest request, String redirectPath) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Clearing access token for connection {} and user {}", (Object)connection.name(), (Object)request.getUserPrincipal());
        }
        this.tokenStore.clearAccessToken(connection, request.getResourceResolver());
        return new OAuthTokenResponse(Optional.empty(), connection, request, redirectPath);
    }

    @Override
    public void clearAccessToken(ClientConnection connection, ResourceResolver resolver) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Clearing access token for connection {} and user {}", (Object)connection.name(), (Object)resolver.getUserID());
        }
        this.tokenStore.clearAccessToken(connection, resolver);
    }
}

