/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.auth.oauth_client.impl.OAuthException;
import org.osgi.service.component.annotations.Component;

@Component(service={OidcProviderMetadataRegistry.class})
public class OidcProviderMetadataRegistry {
    private final ConcurrentMap<String, OIDCProviderMetadata> cache = new ConcurrentHashMap<String, OIDCProviderMetadata>();

    protected OIDCProviderMetadata getProviderMetadata(String base) {
        return this.cache.computeIfAbsent(base, s -> {
            try {
                return OIDCProviderMetadata.resolve((Issuer)new Issuer(s));
            }
            catch (GeneralException | IOException e) {
                throw new OAuthException(e);
            }
        });
    }

    public URI getTokenEndpoint(String base) {
        return this.getProviderMetadata(base).getTokenEndpointURI();
    }

    public URI getAuthorizationEndpoint(String base) {
        return this.getProviderMetadata(base).getAuthorizationEndpointURI();
    }
}

