/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OidcProviderMetadataRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class, factory=true)
public class OidcConnectionImpl
implements ClientConnection {
    private final Config cfg;
    private final OidcProviderMetadataRegistry metadataRegistry;

    @Activate
    public OidcConnectionImpl(Config cfg, @Reference OidcProviderMetadataRegistry metadataRegistry) {
        this.cfg = cfg;
        this.metadataRegistry = metadataRegistry;
    }

    @Override
    public String name() {
        return this.cfg.name();
    }

    public String baseUrl() {
        return this.cfg.baseUrl();
    }

    public String authorizationEndpoint() {
        return this.metadataRegistry.getAuthorizationEndpoint(this.cfg.baseUrl()).toString();
    }

    public String tokenEndpoint() {
        return this.metadataRegistry.getTokenEndpoint(this.cfg.baseUrl()).toString();
    }

    public String clientId() {
        return this.cfg.clientId();
    }

    public String clientSecret() {
        return this.cfg.clientSecret();
    }

    public String[] scopes() {
        return this.cfg.scopes();
    }

    public String[] additionalAuthorizationParameters() {
        return this.cfg.additionalAuthorizationParameters();
    }

    @ObjectClassDefinition(name="OpenID Connect connection details")
    public static @interface Config {
        public String name();

        public String baseUrl();

        public String clientId();

        @AttributeDefinition(type=AttributeType.PASSWORD)
        public String clientSecret();

        public String[] scopes();

        public String[] additionalAuthorizationParameters();

        public String webconsole_configurationFactory_nameHint() default "Name: {name}, base URL: {baseUrl}, clientId: {clientId}";
    }
}

