/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.Covering;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.json4s.JValue;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\r5a\u0001B\u001f?\u00016C\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\t}\u0002\u0011\t\u0012)A\u0005e\"Iq\u0010\u0001BK\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003'\u0001!\u0011#Q\u0001\n\u0005\r\u0001BCA\u000b\u0001\tU\r\u0011\"\u0001\u0002\u0002!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!a\u0001\t\u0015\u0005e\u0001A!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0002*\u0001\u0011\t\u0012)A\u0005\u0003;A!\"a\u000b\u0001\u0005+\u0007I\u0011AA\u0017\u0011)\t)\u0004\u0001B\tB\u0003%\u0011q\u0006\u0005\u000b\u0003o\u0001!Q3A\u0005\u0002\u0005e\u0002BCA+\u0001\tE\t\u0015!\u0003\u0002<!Q\u0011q\u000b\u0001\u0003\u0016\u0004%\t!!\u0017\t\u0015\u0005-\u0004A!E!\u0002\u0013\tY\u0006\u0003\u0006\u0002n\u0001\u0011)\u001a!C\u0001\u0003_B!\"!\u001f\u0001\u0005#\u0005\u000b\u0011BA9\u0011\u001d\tY\b\u0001C\u0001\u0003{B\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005]\u0005\u0001)A\u0005\u0003gB\u0011\"!'\u0001\u0005\u0004%I!!&\t\u0011\u0005m\u0005\u0001)A\u0005\u0003gB\u0011\"!(\u0001\u0001\u0004%I!!&\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005\u0005\u0006\u0002CAW\u0001\u0001\u0006K!a\u001d\t\u0013\u0005=\u0006\u00011A\u0005\n\u0005U\u0005\"CAY\u0001\u0001\u0007I\u0011BAZ\u0011!\t9\f\u0001Q!\n\u0005M\u0004\"CA]\u0001\t\u0007I\u0011AA^\u0011!\t)\u000e\u0001Q\u0001\n\u0005u\u0006bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\tE\u0002\u0001\"\u0011\u00034!I!1\b\u0001\u0002\u0002\u0013\u0005!Q\b\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0001\u0005#B\u0011Ba\u001a\u0001#\u0003%\tA!\u001b\t\u0013\t5\u0004!%A\u0005\u0002\t%\u0004\"\u0003B8\u0001E\u0005I\u0011\u0001B9\u0011%\u0011)\bAI\u0001\n\u0003\u00119\bC\u0005\u0003|\u0001\t\n\u0011\"\u0001\u0003~!I!\u0011\u0011\u0001\u0012\u0002\u0013\u0005!1\u0011\u0005\n\u0005\u000f\u0003\u0011\u0013!C\u0001\u0005\u0013C\u0011B!$\u0001\u0003\u0003%\tEa$\t\u0013\tU\u0005!!A\u0005\u0002\u0005U\u0005\"\u0003BL\u0001\u0005\u0005I\u0011\u0001BM\u0011%\u0011\u0019\u000bAA\u0001\n\u0003\u0012)\u000bC\u0005\u00030\u0002\t\t\u0011\"\u0001\u00032\"I!Q\u0017\u0001\u0002\u0002\u0013\u0005#q\u0017\u0005\n\u0005w\u0003\u0011\u0011!C!\u0005{C\u0011Ba0\u0001\u0003\u0003%\tE!1\t\u0013\t\r\u0007!!A\u0005B\t\u0015w!\u0003Be}\u0005\u0005\t\u0012\u0001Bf\r!id(!A\t\u0002\t5\u0007bBA>o\u0011\u0005!1\u001d\u0005\n\u0005\u007f;\u0014\u0011!C#\u0005\u0003D\u0011B!:8\u0003\u0003%\tIa:\t\u0013\tex'!A\u0005\u0002\nm\b\"CB\u0005o\u0005\u0005I\u0011BB\u0006\u0005%\u0019F/Y2CCR\u001c\u0007N\u0003\u0002@\u0001\u0006!1\u000f^1d\u0015\t\t%)\u0001\u0002j_*\u00111\tR\u0001\u000bg\u0016$wN\\1`gFd'BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011#\u0002\u0001O-z#\u0007CA(U\u001b\u0005\u0001&BA)S\u0003\u0011a\u0017M\\4\u000b\u0003M\u000bAA[1wC&\u0011Q\u000b\u0015\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u0002:fC\u0012T!a\u0017#\u0002\u0013\r|gN\\3di>\u0014\u0018BA/Y\u0005\u0015\u0011\u0015\r^2i!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Z7\u000f\u0005\u0019\\gBA4k\u001b\u0005A'BA5M\u0003\u0019a$o\\8u}%\t\u0011-\u0003\u0002mA\u00069\u0001/Y2lC\u001e,\u0017B\u00018p\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ta\u0007-A\u0007ce>\fGmY1ti\u000e{gNZ\u000b\u0002eB\u00191O\u001e=\u000e\u0003QT!!\u001e$\u0002\u0013\t\u0014x.\u00193dCN$\u0018BA<u\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u0002zy6\t!P\u0003\u0002|\r\u0006!Q\u000f^5m\u0013\ti(PA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0017A\u00042s_\u0006$7-Y:u\u0007>tg\rI\u0001\u0012gR\f7mQ8mY\u0016\u001cG/[8o+JdWCAA\u0002!\u0011\t)!!\u0004\u000f\t\u0005\u001d\u0011\u0011\u0002\t\u0003O\u0002L1!a\u0003a\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00021\u0002%M$\u0018mY\"pY2,7\r^5p]V\u0013H\u000eI\u0001\u0013gR\f7mQ8mY\u0016\u001cG/[8o\u0015N|g.A\nti\u0006\u001c7i\u001c7mK\u000e$\u0018n\u001c8Kg>t\u0007%\u0001\u0004tG\",W.Y\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G!\u0015!\u0002;za\u0016\u001c\u0018\u0002BA\u0014\u0003C\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003\u001d\u00198\r[3nC\u0002\nAa\u001c9ugV\u0011\u0011q\u0006\t\t\u0003\u000b\t\t$a\u0001\u0002\u0004%!\u00111GA\t\u0005\ri\u0015\r]\u0001\u0006_B$8\u000fI\u0001\u000egB\fG/[1m\r&dG/\u001a:\u0016\u0005\u0005m\u0002#B0\u0002>\u0005\u0005\u0013bAA A\n1q\n\u001d;j_:\u0004B!a\u0011\u0002R5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0006hK>\u0004\u0018M]9vKRTA!a\u0013\u0002N\u0005YA-\u0019;bg>,(oY3t\u0015\r\ty\u0005R\u0001\nKb,7-\u001e;j_:LA!a\u0015\u0002F\t9r)Z8QCJ\fX/\u001a;Ta\u0006$\u0018.\u00197GS2$XM]\u0001\u000fgB\fG/[1m\r&dG/\u001a:!\u00039!X-\u001c9pe\u0006dg)\u001b7uKJ,\"!a\u0017\u0011\u000b}\u000bi$!\u0018\u0011\t\u0005}\u0013qM\u0007\u0003\u0003CR1aPA2\u0015\u0011\t)'!\u0014\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u0003\u0002j\u0005\u0005$A\u0004+f[B|'/\u00197GS2$XM]\u0001\u0010i\u0016l\u0007o\u001c:bY\u001aKG\u000e^3sA\u0005YA.[7ji\u001aKG\u000e^3s+\t\t\t\bE\u0003`\u0003{\t\u0019\bE\u0002`\u0003kJ1!a\u001ea\u0005\rIe\u000e^\u0001\rY&l\u0017\u000e\u001e$jYR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005}\u00141QAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006=\u0015\u0011\u0013\t\u0004\u0003\u0003\u0003Q\"\u0001 \t\u000bA\f\u0002\u0019\u0001:\t\r}\f\u0002\u0019AA\u0002\u0011\u001d\t)\"\u0005a\u0001\u0003\u0007Aq!!\u0007\u0012\u0001\u0004\ti\u0002C\u0004\u0002,E\u0001\r!a\f\t\u000f\u0005]\u0012\u00031\u0001\u0002<!9\u0011qK\tA\u0002\u0005m\u0003bBA7#\u0001\u0007\u0011\u0011O\u0001\u001cI\u00164\u0017-\u001e7u\u0013R,Wn\u001d'j[&$\b+\u001a:SKF,Xm\u001d;\u0016\u0005\u0005M\u0014\u0001\b3fM\u0006,H\u000e^%uK6\u001cH*[7jiB+'OU3rk\u0016\u001cH\u000fI\u0001 SR,Wn\u001d'pC\u0012\u0004&o\\2fgN\u0014V\r]8siRC'/Z:i_2$\u0017\u0001I5uK6\u001cHj\\1e!J|7-Z:t%\u0016\u0004xN\u001d;UQJ,7\u000f[8mI\u0002\n1\"\u001b;f[6\u000b\u0007\u0010T3gi\u0006y\u0011\u000e^3n\u001b\u0006DH*\u001a4u?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0006%\u0006cA0\u0002&&\u0019\u0011q\u00151\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003W;\u0012\u0011!a\u0001\u0003g\n1\u0001\u001f\u00132\u00031IG/Z7NCbdUM\u001a;!\u0003=a\u0017m\u001d;SKB|'\u000f^\"pk:$\u0018a\u00057bgR\u0014V\r]8si\u000e{WO\u001c;`I\u0015\fH\u0003BAR\u0003kC\u0011\"a+\u001b\u0003\u0003\u0005\r!a\u001d\u0002!1\f7\u000f\u001e*fa>\u0014HoQ8v]R\u0004\u0013AB7baB,'/\u0006\u0002\u0002>B!\u0011qXAi\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\t\u0005\u001d\u0017\u0011Z\u0001\bU\u0006\u001c7n]8o\u0015\u0011\tY-!4\u0002\u0013\u0019\f7\u000f^3sq6d'BAAh\u0003\r\u0019w.\\\u0005\u0005\u0003'\f\tM\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u001dM,G/\u0013;f[6\u000b\u0007\u0010T3giR!\u00111UAn\u0011\u001d\tiN\ba\u0001\u0003g\nQA^1mk\u0016\f1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$\"!a9\u0011\u000b}\u000b)/!;\n\u0007\u0005\u001d\bMA\u0003BeJ\f\u0017\u0010E\u0002X\u0003WL1!!<Y\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:\f\u0001cY8mY\u0016\u001cG/\u0013;f[2Kgn[:\u0015\u0015\u0005\r\u00161_A|\u0003w\u0014y\u0001C\u0004\u0002v\u0002\u0002\r!a\u0001\u0002%\r|G\u000e\\3di&|gNQ1tKB\u000bG\u000f\u001b\u0005\b\u0003s\u0004\u0003\u0019AA\u0002\u00039\u0019w\u000e\u001c7fGRLwN\u001c&t_:Dq!!@!\u0001\u0004\ty0A\u0005ji\u0016lG*\u001b8lgB1!\u0011\u0001B\u0006\u0003\u0007i!Aa\u0001\u000b\t\t\u0015!qA\u0001\b[V$\u0018M\u00197f\u0015\r\u0011I\u0001Y\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0007\u0005\u0007\u00111\"\u0011:sCf\u0014UO\u001a4fe\"9!\u0011\u0003\u0011A\u0002\tM\u0011A\u00058fK\u0012\u001cu.\u001e8u\u001d\u0016DH/\u0013;f[N\u00042a\u0018B\u000b\u0013\r\u00119\u0002\u0019\u0002\b\u0005>|G.Z1o\u0003-9W\r^%uK6d\u0015N\\6\u0015\u0015\u0005\r!Q\u0004B\u0011\u0005G\u0011)\u0003C\u0004\u0003 \u0005\u0002\r!a\u0001\u0002\u000f%$X-\\+sY\"9\u00111S\u0011A\u0002\u0005M\u0004bBA\u001cC\u0001\u0007\u00111\b\u0005\b\u0003/\n\u0003\u0019AA.\u0003A1\u0017\u000e\u001c;fe\u000e{G\u000e\\3di&|g\u000e\u0006\u0005\u0003\u0014\t-\"Q\u0006B\u0018\u0011\u001d\tIP\ta\u0001\u0003\u0007Aq!a\u000e#\u0001\u0004\tY\u0004C\u0004\u0002X\t\u0002\r!a\u0017\u0002'\r\u0014X-\u0019;f%\u0016\fG-\u001a:GC\u000e$xN]=\u0015\u0005\tU\u0002cA,\u00038%\u0019!\u0011\b-\u0003-A\u000b'\u000f^5uS>t'+Z1eKJ4\u0015m\u0019;pef\fAaY8qsR\u0011\u0012q\u0010B \u0005\u0003\u0012\u0019E!\u0012\u0003H\t%#1\nB'\u0011\u001d\u0001H\u0005%AA\u0002ID\u0001b \u0013\u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0003+!\u0003\u0013!a\u0001\u0003\u0007A\u0011\"!\u0007%!\u0003\u0005\r!!\b\t\u0013\u0005-B\u0005%AA\u0002\u0005=\u0002\"CA\u001cIA\u0005\t\u0019AA\u001e\u0011%\t9\u0006\nI\u0001\u0002\u0004\tY\u0006C\u0005\u0002n\u0011\u0002\n\u00111\u0001\u0002r\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B*U\r\u0011(QK\u0016\u0003\u0005/\u0002BA!\u0017\u0003d5\u0011!1\f\u0006\u0005\u0005;\u0012y&A\u0005v]\u000eDWmY6fI*\u0019!\u0011\r1\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003f\tm#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B6U\u0011\t\u0019A!\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B:U\u0011\tiB!\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!\u0011\u0010\u0016\u0005\u0003_\u0011)&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t}$\u0006BA\u001e\u0005+\nabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\u0006*\"\u00111\fB+\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"Aa#+\t\u0005E$QK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0005cA(\u0003\u0014&\u0019\u0011q\u0002)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0014BQ!\ry&QT\u0005\u0004\u0005?\u0003'aA!os\"I\u00111V\u0018\u0002\u0002\u0003\u0007\u00111O\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0015\t\u0007\u0005S\u0013YKa'\u000e\u0005\t\u001d\u0011\u0002\u0002BW\u0005\u000f\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0003BZ\u0011%\tY+MA\u0001\u0002\u0004\u0011Y*\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BI\u0005sC\u0011\"a+3\u0003\u0003\u0005\r!a\u001d\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!%\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019Ba2\t\u0013\u0005-V'!AA\u0002\tm\u0015!C*uC\u000e\u0014\u0015\r^2i!\r\t\tiN\n\u0006o\t='1\u001c\t\u0016\u0005#\u00149N]A\u0002\u0003\u0007\ti\"a\f\u0002<\u0005m\u0013\u0011OA@\u001b\t\u0011\u0019NC\u0002\u0003V\u0002\fqA];oi&lW-\u0003\u0003\u0003Z\nM'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oqA!!Q\u001cBq\u001b\t\u0011yN\u0003\u0002B%&\u0019aNa8\u0015\u0005\t-\u0017!B1qa2LHCEA@\u0005S\u0014YO!<\u0003p\nE(1\u001fB{\u0005oDQ\u0001\u001d\u001eA\u0002IDaa \u001eA\u0002\u0005\r\u0001bBA\u000bu\u0001\u0007\u00111\u0001\u0005\b\u00033Q\u0004\u0019AA\u000f\u0011\u001d\tYC\u000fa\u0001\u0003_Aq!a\u000e;\u0001\u0004\tY\u0004C\u0004\u0002Xi\u0002\r!a\u0017\t\u000f\u00055$\b1\u0001\u0002r\u00059QO\\1qa2LH\u0003\u0002B\u007f\u0007\u000b\u0001RaXA\u001f\u0005\u007f\u0004\"cXB\u0001e\u0006\r\u00111AA\u000f\u0003_\tY$a\u0017\u0002r%\u001911\u00011\u0003\rQ+\b\u000f\\39\u0011%\u00199aOA\u0001\u0002\u0004\ty(A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012A\u0014")
public class StacBatch
implements Batch,
Product,
Serializable {
    private final Broadcast<SerializableConfiguration> broadcastConf;
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final Option<Object> limitFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;

    public static Option<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>> unapply(StacBatch x$0) {
        return StacBatch$.MODULE$.unapply(x$0);
    }

    public static StacBatch apply(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return StacBatch$.MODULE$.apply(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public static Function1<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<Broadcast<SerializableConfiguration>, Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, Function1<Option<Object>, StacBatch>>>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Broadcast<SerializableConfiguration> broadcastConf() {
        return this.broadcastConf;
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    public Option<Object> limitFilter() {
        return this.limitFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        Some some;
        int limit;
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option<Object> option = this.limitFilter();
        int itemsLimitMax = option instanceof Some && (limit = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 0 ? limit : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable)() -> "1"))));
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((IterableOnceOps)((StrictOptimizedIterableOps)itemLinks.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String item = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                }
                throw new MatchError((Object)tuple2);
            })).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])((IterableOps)Random$.MODULE$.shuffle((IterableOnce)itemLinks, BuildFrom$.MODULE$.buildFromIterableOps())).grouped(partitionSize).zipWithIndex().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ArrayBuffer items = (ArrayBuffer)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            }
            throw new MatchError((Object)tuple2);
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                Growable growable = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(this.getItemLink(itemUrl, this.defaultItemsLimitPerRequest(), this.spatialFilter(), this.temporalFilter()), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public String getItemLink(String itemUrl, int defaultItemsLimitPerRequest, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String baseUrl = new StringBuilder(7).append(itemUrl).append("?limit=").append(defaultItemsLimitPerRequest).toString();
        String urlWithFilters = StacUtils$.MODULE$.addFiltersToUrl(baseUrl, spatialFilter, temporalFilter);
        return urlWithFilters;
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl = !intervals.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader(this.broadcastConf(), (StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return new StacBatch(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public Broadcast<SerializableConfiguration> copy$default$1() {
        return this.broadcastConf();
    }

    public String copy$default$2() {
        return this.stacCollectionUrl();
    }

    public String copy$default$3() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$4() {
        return this.schema();
    }

    public Map<String, String> copy$default$5() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$6() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$7() {
        return this.temporalFilter();
    }

    public Option<Object> copy$default$8() {
        return this.limitFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.broadcastConf();
            }
            case 1: {
                return this.stacCollectionUrl();
            }
            case 2: {
                return this.stacCollectionJson();
            }
            case 3: {
                return this.schema();
            }
            case 4: {
                return this.opts();
            }
            case 5: {
                return this.spatialFilter();
            }
            case 6: {
                return this.temporalFilter();
            }
            case 7: {
                return this.limitFilter();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "broadcastConf";
            }
            case 1: {
                return "stacCollectionUrl";
            }
            case 2: {
                return "stacCollectionJson";
            }
            case 3: {
                return "schema";
            }
            case 4: {
                return "opts";
            }
            case 5: {
                return "spatialFilter";
            }
            case 6: {
                return "temporalFilter";
            }
            case 7: {
                return "limitFilter";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastConf();
        Broadcast<SerializableConfiguration> broadcast2 = stacBatch.broadcastConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.limitFilter();
        Option<Object> option6 = stacBatch.limitFilter();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            .colon.colon geometryTypes = new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
            Seq bbox = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
            GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
            return filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LocalDateTime start = (LocalDateTime)tuple2._1();
            LocalDateTime end = (LocalDateTime)tuple2._2();
            return filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        }
        throw new MatchError((Object)tuple2);
    }

    public StacBatch(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        this.broadcastConf = broadcastConf;
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        this.limitFilter = limitFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        int limitPerRequest = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable)() -> "10")));
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable)() -> "1000000")));
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
    }
}

