/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$ParquetOutputTimestampType$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\t\u0012\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A1\b\u0001B\u0001B\u0003%!\u0006C\u0003=\u0001\u0011\u0005Q\bC\u0003=\u0001\u0011\u0005!\tC\u0003=\u0001\u0011\u0005\u0001\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003d\u0001\u0011\u0005A\rC\u0003d\u0001\u0011%QnB\u0004y#\u0005\u0005\t\u0012A=\u0007\u000fA\t\u0012\u0011!E\u0001u\")Ah\u0003C\u0001w\"9ApCI\u0001\n\u0003i\b\"CA\t\u0017E\u0005I\u0011AA\n\u0011!\t9bCI\u0001\n\u0003i(!H*qCJ\\Gk\u001c)beF,X\r^*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u000b\u0005I\u0019\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q)\u0012AC4f_B\f'/];fi*\u0011acF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u00193\u0005IQ\r_3dkRLwN\u001c\u0006\u00035m\t1a]9m\u0015\taR$A\u0003ta\u0006\u00148N\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017\u0001G<sSR,G*Z4bGf\u0004\u0016M]9vKR4uN]7biB\u0011AeK\u0005\u0003Y\u0015\u0012qAQ8pY\u0016\fg.A\npkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X\r\u0005\u00020o9\u0011\u0001\u0007\u000e\b\u0003cIj\u0011!E\u0005\u0003gE\tq\u0002U8si\u0006\u0014G.Z*R\u0019\u000e{gNZ\u0005\u0003kY\n!\u0004U1scV,GoT;uaV$H+[7fgR\fW\u000e\u001d+za\u0016T!aM\t\n\u0005aJ$!\u0002,bYV,\u0017B\u0001\u001e&\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u0015U\u001cXMR5fY\u0012LE-\u0001\u0004=S:LGO\u0010\u000b\u0005}}\u0002\u0015\t\u0005\u00022\u0001!9\u0011\u0006\u0002I\u0001\u0002\u0004Q\u0003bB\u0017\u0005!\u0003\u0005\rA\f\u0005\bw\u0011\u0001\n\u00111\u0001+)\tq4\tC\u0003E\u000b\u0001\u0007Q)\u0001\u0003d_:4\u0007CA\u0019G\u0013\t9\u0015CA\bQ_J$\u0018M\u00197f'Fc5i\u001c8g)\tq\u0014\nC\u0003E\r\u0001\u0007!\n\u0005\u0002L\u001f6\tAJ\u0003\u0002E\u001b*\u0011a*H\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ac%!D\"p]\u001aLw-\u001e:bi&|g.A\u0004d_:4XM\u001d;\u0015\u0005M[\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0019\u00198\r[3nC*\u0011\u0001,H\u0001\ba\u0006\u0014\u0018/^3u\u0013\tQVKA\u0006NKN\u001c\u0018mZ3UsB,\u0007\"\u0002/\b\u0001\u0004i\u0016AD2bi\u0006d\u0017p\u001d;TG\",W.\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Af\tQ\u0001^=qKNL!AY0\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0007d_:4XM\u001d;GS\u0016dG\r\u0006\u0002fQB\u0011AKZ\u0005\u0003OV\u0013A\u0001V=qK\")\u0011\u000e\u0003a\u0001U\u0006)a-[3mIB\u0011al[\u0005\u0003Y~\u00131b\u0015;sk\u000e$h)[3mIR\u0019QM\\8\t\u000b%L\u0001\u0019\u00016\t\u000bAL\u0001\u0019A9\u0002\u0015I,\u0007/\u001a;ji&|g\u000e\u0005\u0002sk:\u0011Ak]\u0005\u0003iV\u000bA\u0001V=qK&\u0011ao\u001e\u0002\u000b%\u0016\u0004X\r^5uS>t'B\u0001;V\u0003u\u0019\u0006/\u0019:l)>\u0004\u0016M]9vKR\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\bCA\u0019\f'\tY1\u0005F\u0001z\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\taP\u000b\u0002+\u007f.\u0012\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0002\f\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty!!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003+Q#AL@\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;
    private final boolean useFieldId;

    public static boolean $lessinit$greater$default$3() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Enumeration.Value $lessinit$greater$default$2() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((TraversableOnce)catalystSchema.map((Function1 & Serializable & scala.Serializable)field -> this.convertField((StructField)field), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    /*
     * WARNING - void declaration
     */
    public Type convertField(StructField field) {
        void var2_2;
        Type converted = this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
        return this.useFieldId && ParquetUtils$.MODULE$.hasFieldId(field) ? converted.withId(ParquetUtils$.MODULE$.getFieldId(field)) : var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type convertField(StructField field2, Type.Repetition repetition) {
        Option option;
        Option option2;
        Option option3;
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true)).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true)).named(field2.name());
        }
        boolean bl4 = IntegerType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType;
        if (bl4) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        boolean bl5 = LongType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType;
        if (bl5) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType()).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            Type type;
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = PortableSQLConf$ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
                return type;
            }
            Enumeration.Value value4 = PortableSQLConf$ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
                return type;
            }
            Enumeration.Value value6 = PortableSQLConf$ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (value6 == null) {
                if (value7 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value6.equals(value7)) throw new MatchError((Object)value);
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)).named(field2.name());
            return type;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl6 = arrayType.containsNull();
            if (bl6 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()))).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl7 = arrayType.containsNull();
            if (!bl7 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4())), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4())));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()))).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()))).named("key_value")).named(field2.name());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).foldLeft((Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable & scala.Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field)))).named(field2.name());
        }
        if (!(dataType instanceof UserDefinedType)) throw QueryCompilationErrors$.MODULE$.cannotConvertDataTypeToParquetTypeError(field2);
        UserDefinedType userDefinedType = (UserDefinedType)dataType;
        DataType x$1 = userDefinedType.sqlType();
        String x$2 = field2.copy$default$1();
        boolean x$3 = field2.copy$default$3();
        Metadata x$4 = field2.copy$default$4();
        return this.convertField(field2.copy(x$2, x$1, x$3, x$4));
    }

    public SparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType, boolean useFieldId) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
        this.useFieldId = useFieldId;
    }

    public SparkToParquetSchemaConverter(PortableSQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType(), conf.parquetFieldIdWriteEnabled());
    }

    public SparkToParquetSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(PortableSQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean(), PortableSQLConf$ParquetOutputTimestampType$.MODULE$.withName(conf.get(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())), new StringOps(Predef$.MODULE$.augmentString(conf.get(PortableSQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key()))).toBoolean());
    }
}

