/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.DataTypeUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFilters;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetOptions;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.RebaseSpec;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001\u0002\f\u0018\u0001\u0019B\u0001B\u0012\u0001\u0003\u0006\u0004%\ta\u0012\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0011\")q\n\u0001C\u0001!\")q\n\u0001C\u0001'\")A\u000b\u0001C!+\")a\f\u0001C!?\")1\r\u0001C!I\")\u0001\u000f\u0001C\u0001c\")1\u000f\u0001C!i\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\t\u0019\f\u0001C!\u0003k;q!!0\u0018\u0011\u0003\tyL\u0002\u0004\u0017/!\u0005\u0011\u0011\u0019\u0005\u0007\u001f>!\t!!3\t\u000f\u0005-w\u0002\"\u0001\u0002N\"9\u0011q[\b\u0005\n\u0005e\u0007b\u0002B\u0006\u001f\u0011%!Q\u0002\u0005\b\u0005/yA\u0011\u0002B\r\u0011%\u0011\tcDA\u0001\n\u0013\u0011\u0019C\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u00031e\t!bZ3pa\u0006\u0014\u0018/^3u\u0015\tQ2$A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u000f\u001e\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0004\u0001O5\nTg\u000f!\u0011\u0005!ZS\"A\u0015\u000b\u0005):\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00051J#!\u0005)beF,X\r\u001e$jY\u00164uN]7biB\u0011afL\u0007\u0002/%\u0011\u0001g\u0006\u0002\u0019\u000f\u0016|\u0007+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;CCN,\u0007C\u0001\u001a4\u001b\u0005I\u0012B\u0001\u001b\u001a\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003mej\u0011a\u000e\u0006\u0003qu\tqa]8ve\u000e,7/\u0003\u0002;o\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\tad(D\u0001>\u0015\tQs$\u0003\u0002@{\t9Aj\\4hS:<\u0007CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017!D:qCRL\u0017\r\u001c$jYR,'/F\u0001I!\r\t\u0015jS\u0005\u0003\u0015\n\u0013aa\u00149uS>t\u0007C\u0001\u0018M\u0013\tiuCA\fHK>\u0004\u0016M]9vKR\u001c\u0006/\u0019;jC24\u0015\u000e\u001c;fe\u0006q1\u000f]1uS\u0006dg)\u001b7uKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002R%B\u0011a\u0006\u0001\u0005\u0006\r\u000e\u0001\r\u0001\u0013\u000b\u0002#\u00061Q-];bYN$\"AV-\u0011\u0005\u0005;\u0016B\u0001-C\u0005\u001d\u0011un\u001c7fC:DQAW\u0003A\u0002m\u000bQa\u001c;iKJ\u0004\"!\u0011/\n\u0005u\u0013%aA!os\u0006A\u0001.Y:i\u0007>$W\rF\u0001a!\t\t\u0015-\u0003\u0002c\u0005\n\u0019\u0011J\u001c;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001a\t\u0003M6t!aZ6\u0011\u0005!\u0014U\"A5\u000b\u0005),\u0013A\u0002\u001fs_>$h(\u0003\u0002m\u0005\u00061\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta')A\u000bxSRD7\u000b]1uS\u0006d\u0007K]3eS\u000e\fG/Z:\u0015\u0005E\u0013\b\"\u0002$\t\u0001\u0004Y\u0015aC5oM\u0016\u00148k\u00195f[\u0006$b!\u001e?\u0002\u0006\u0005=\u0001cA!JmB\u0011qO_\u0007\u0002q*\u0011\u00110H\u0001\u0006if\u0004Xm]\u0005\u0003wb\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015i\u0018\u00021\u0001\u007f\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\ry\u0018\u0011A\u0007\u0002;%\u0019\u00111A\u000f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\n\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\u000b\u0019\fY!Z3\n\u0007\u00055qNA\u0002NCBDq!!\u0005\n\u0001\u0004\t\u0019\"A\u0003gS2,7\u000f\u0005\u0004\u0002\u0016\u0005}\u0011Q\u0005\b\u0005\u0003/\tYBD\u0002i\u00033I\u0011aQ\u0005\u0004\u0003;\u0011\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003C\t\u0019CA\u0002TKFT1!!\bC!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t!AZ:\u000b\u0007\u0005=\u0012%\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003g\tIC\u0001\u0006GS2,7\u000b^1ukN\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$\"\"!\u000f\u0002@\u0005\u0005\u0013\u0011KA+!\r\u0011\u00141H\u0005\u0004\u0003{I\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"B?\u000b\u0001\u0004q\bbBA\"\u0015\u0001\u0007\u0011QI\u0001\u0004U>\u0014\u0007\u0003BA$\u0003\u001bj!!!\u0013\u000b\t\u0005-\u0013QF\u0001\n[\u0006\u0004(/\u001a3vG\u0016LA!a\u0014\u0002J\t\u0019!j\u001c2\t\u000f\u0005M#\u00021\u0001\u0002\n\u00059q\u000e\u001d;j_:\u001c\bBBA,\u0015\u0001\u0007a/\u0001\u0006eCR\f7k\u00195f[\u0006\faDY;jY\u0012\u0014V-\u00193fe^KG\u000f\u001b)beRLG/[8o-\u0006dW/Z:\u0015!\u0005u\u00131PA?\u0003\u007f\n\u0019)a\"\u0002\u0014\u0006U\u0005cB!\u0002`\u0005\r\u0014\u0011N\u0005\u0004\u0003C\u0012%!\u0003$v]\u000e$\u0018n\u001c82!\r\u0011\u0014QM\u0005\u0004\u0003OJ\"a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\r\u0005U\u00111NA8\u0013\u0011\ti'a\t\u0003\u0011%#XM]1u_J\u0004B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003kj\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005e\u00141\u000f\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003~\u0017\u0001\u0007a\u0010\u0003\u0004\u0002X-\u0001\rA\u001e\u0005\u0007\u0003\u0003[\u0001\u0019\u0001<\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Da!!\"\f\u0001\u00041\u0018A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\b\u0003\u0013[\u0001\u0019AAF\u0003\u001d1\u0017\u000e\u001c;feN\u0004b!!\u0006\u0002 \u00055\u0005c\u0001\u001c\u0002\u0010&\u0019\u0011\u0011S\u001c\u0003\r\u0019KG\u000e^3s\u0011\u001d\t\u0019f\u0003a\u0001\u0003\u0013Aq!a&\f\u0001\u0004\tI*\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000bi#\u0001\u0003d_:4\u0017\u0002BAR\u0003;\u0013QbQ8oM&<WO]1uS>t\u0017aD:vaB|'\u000f\u001e#bi\u0006$\u0016\u0010]3\u0015\u0007Y\u000bI\u000bC\u0004\u0002,2\u0001\r!!,\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042a^AX\u0013\r\t\t\f\u001f\u0002\t\t\u0006$\u0018\rV=qK\u0006a1/\u001e9q_J$()\u0019;dQR)a+a.\u0002:\")Q0\u0004a\u0001}\"1\u00111X\u0007A\u0002Y\faa]2iK6\f\u0017\u0001F$f_B\u000b'/];fi\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002/\u001fM)q\"a1<\u0001B\u0019\u0011)!2\n\u0007\u0005\u001d'I\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u007f\u000ba#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\bk\u0006=\u0017\u0011[Ak\u0011\u001d\t9!\u0005a\u0001\u0003\u0013Aq!a5\u0012\u0001\u0004\t\u0019\"\u0001\u0007gS2,7\u000fV8U_V\u001c\u0007\u000eC\u0003~#\u0001\u0007a0\u0001\u000bsK\u0006$7k\u00195f[\u00064%o\\7G_>$XM\u001d\u000b\nm\u0006m\u0017Q^A\u0000\u0005\u0013Aq!!8\u0013\u0001\u0004\ty.\u0001\u0004g_>$XM\u001d\t\u0005\u0003C\fI/\u0004\u0002\u0002d*!\u0011qFAs\u0015\r\t9/I\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\tY/a9\u0003\r\u0019{w\u000e^3s\u0011\u001d\tyO\u0005a\u0001\u0003c\f\u0001c[3z-\u0006dW/Z'fi\u0006$\u0015\r^1\u0011\r\u0005M\u0018Q`3f\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018\u0001B;uS2T!!a?\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\t)\u0010C\u0004\u0003\u0002I\u0001\rAa\u0001\u0002\u0013\r|gN^3si\u0016\u0014\bc\u0001\u0018\u0003\u0006%\u0019!qA\f\u0003A\u001d+w\u000eU1scV,G\u000fV8Ta\u0006\u00148nU2iK6\f7i\u001c8wKJ$XM\u001d\u0005\b\u0003\u000f\u0011\u0002\u0019AA\u0005\u0003]!Wm]3sS\u0006d\u0017N_3TG\",W.Y*ue&tw\rF\u0004v\u0005\u001f\u0011\u0019B!\u0006\t\r\tE1\u00031\u0001f\u00031\u00198\r[3nCN#(/\u001b8h\u0011\u001d\tyo\u0005a\u0001\u0003cDq!a\u0002\u0014\u0001\u0004\tI!\u0001\u0013sKBd\u0017mY3HK>lW\r\u001e:z\u0007>dW/\u001c8XSRDw)Z8nKR\u0014\u00180\u0016#U)\u001d1(1\u0004B\u000f\u0005?Aa!a/\u0015\u0001\u00041\bbBAx)\u0001\u0007\u0011\u0011\u001f\u0005\b\u0003\u000f!\u0002\u0019AA\u0005\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0002\u0003\u0002B\u0014\u0005[i!A!\u000b\u000b\t\t-\u0012\u0011`\u0001\u0005Y\u0006tw-\u0003\u0003\u00030\t%\"AB(cU\u0016\u001cG\u000f")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String toString() {
        return new StringBuilder(10).append("GeoParquet").append(this.spatialFilter().map((Function1 & Serializable & scala.Serializable)filter -> new StringBuilder(23).append(" with spatial filter [").append(filter.simpleString()).append("]").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        PortableSQLConf sqlConf = new PortableSQLConf(sparkSession.sessionState().conf());
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(PortableSQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(PortableSQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(PortableSQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(PortableSQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        PortableSQLConf conf = new PortableSQLConf(sparkSession.sessionState().conf());
        hadoopConf.set(PortableSQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), conf.sessionLocalTimeZone());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), conf.nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.CASE_SENSITIVE().key(), conf.caseSensitiveAnalysis());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), conf.isParquetBinaryAsString());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), conf.isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), conf.parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), conf.legacyParquetNanosAsLong());
        hadoopConf.setBoolean("spark.databricks.scan.modTimeCheck.enabled", false);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        PortableSQLConf sqlConf = new PortableSQLConf(sparkSession.sessionState().conf());
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean parquetFilterPushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, new PortableSQLConf(sparkSession.sessionState().conf()));
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFooterReader.readFooter(sharedConf, file, true).getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, parquetFilterPushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)x$2)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable & scala.Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(this, metadata)));
            if (!shouldScanFile) {
                iterator = ((IterableLike)Nil$.MODULE$).iterator();
            } else {
                ParquetRecordReader parquetRecordReader;
                None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(PortableSQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                if (enableVectorizedReader) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec, options);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
                RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
                try {
                    readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus(DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    if (partitionSchema.length() == 0) {
                        iterator = iter.map((Function1)unsafeProjection);
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                    }
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$7(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

