/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.spider;

import java.util.Map;
import java.util.Random;
import org.apache.sedona.common.spider.PointBasedGenerator;
import org.locationtech.jts.geom.Coordinate;

public class DiagonalGenerator
extends PointBasedGenerator {
    private static final double INV_SQRT2 = 1.0 / Math.sqrt(2.0);
    private final DiagonalParameter parameter;

    public DiagonalGenerator(Random random, DiagonalParameter diagonalParameter) {
        super(random, diagonalParameter.pointBasedParameter);
        this.parameter = diagonalParameter;
    }

    @Override
    protected Coordinate generateCoordinate() {
        if (this.bernoulli(this.parameter.percentage) == 1) {
            double position = this.uniform(0.0, 1.0);
            return new Coordinate(position, position);
        }
        double c = this.uniform(0.0, 1.0);
        double d = this.normal(0.0, this.parameter.buffer / 5.0);
        double displacement = d * INV_SQRT2;
        double x = c + displacement;
        double y = c - displacement;
        return new Coordinate(x, y);
    }

    public static class DiagonalParameter {
        public final PointBasedGenerator.PointBasedParameter pointBasedParameter;
        public final double percentage;
        public final double buffer;

        public DiagonalParameter(PointBasedGenerator.PointBasedParameter pointBasedParameter, double percentage, double buffer) {
            this.pointBasedParameter = pointBasedParameter;
            this.percentage = percentage;
            this.buffer = buffer;
        }

        public static DiagonalParameter create(Map<String, String> conf) {
            PointBasedGenerator.PointBasedParameter pointBasedParameter = PointBasedGenerator.PointBasedParameter.create(conf);
            double percentage = Double.parseDouble(conf.getOrDefault("percentage", "0.5"));
            double buffer = Double.parseDouble(conf.getOrDefault("buffer", "0.5"));
            if (percentage < 0.0 || percentage > 1.0) {
                throw new IllegalArgumentException("Percentage must be between 0 and 1");
            }
            if (buffer < 0.0) {
                throw new IllegalArgumentException("Buffer must be a non-negative number");
            }
            return new DiagonalParameter(pointBasedParameter, percentage, buffer);
        }
    }
}

