/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.hadoop.test.UnitTestcaseTimeLimit;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestStringUtils
extends UnitTestcaseTimeLimit {
    private static final String NULL_STR = null;
    private static final String EMPTY_STR = "";
    private static final String STR_WO_SPECIAL_CHARS = "AB";
    private static final String STR_WITH_COMMA = "A,B";
    private static final String ESCAPED_STR_WITH_COMMA = "A\\,B";
    private static final String STR_WITH_ESCAPE = "AB\\";
    private static final String ESCAPED_STR_WITH_ESCAPE = "AB\\\\";
    private static final String STR_WITH_BOTH2 = ",A\\,,B\\\\,";
    private static final String ESCAPED_STR_WITH_BOTH2 = "\\,A\\\\\\,\\,B\\\\\\\\\\,";
    private static final FastDateFormat FAST_DATE_FORMAT = FastDateFormat.getInstance((String)"d-MMM-yyyy HH:mm:ss");

    @Test(timeout=30000L)
    public void testEscapeString() throws Exception {
        Assert.assertEquals((Object)NULL_STR, (Object)StringUtils.escapeString((String)NULL_STR));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.escapeString((String)EMPTY_STR));
        Assert.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)StringUtils.escapeString((String)STR_WO_SPECIAL_CHARS));
        Assert.assertEquals((Object)ESCAPED_STR_WITH_COMMA, (Object)StringUtils.escapeString((String)STR_WITH_COMMA));
        Assert.assertEquals((Object)ESCAPED_STR_WITH_ESCAPE, (Object)StringUtils.escapeString((String)STR_WITH_ESCAPE));
        Assert.assertEquals((Object)ESCAPED_STR_WITH_BOTH2, (Object)StringUtils.escapeString((String)STR_WITH_BOTH2));
    }

    @Test(timeout=30000L)
    public void testSplit() throws Exception {
        Assert.assertEquals((Object)NULL_STR, (Object)StringUtils.split((String)NULL_STR));
        String[] splits = StringUtils.split((String)EMPTY_STR);
        Assert.assertEquals((long)0L, (long)splits.length);
        splits = StringUtils.split((String)",,");
        Assert.assertEquals((long)0L, (long)splits.length);
        splits = StringUtils.split((String)STR_WO_SPECIAL_CHARS);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_COMMA);
        Assert.assertEquals((long)2L, (long)splits.length);
        Assert.assertEquals((Object)"A", (Object)splits[0]);
        Assert.assertEquals((Object)"B", (Object)splits[1]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_COMMA);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)ESCAPED_STR_WITH_COMMA, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_ESCAPE);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)STR_WITH_ESCAPE, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_BOTH2);
        Assert.assertEquals((long)3L, (long)splits.length);
        Assert.assertEquals((Object)EMPTY_STR, (Object)splits[0]);
        Assert.assertEquals((Object)"A\\,", (Object)splits[1]);
        Assert.assertEquals((Object)"B\\\\", (Object)splits[2]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_BOTH2);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)ESCAPED_STR_WITH_BOTH2, (Object)splits[0]);
    }

    @Test(timeout=30000L)
    public void testSimpleSplit() throws Exception {
        String[] TO_TEST;
        for (String testSubject : TO_TEST = new String[]{"a/b/c", "a/b/c////", "///a/b/c", EMPTY_STR, "/", "////"}) {
            Assert.assertArrayEquals((String)("Testing '" + testSubject + "'"), (Object[])testSubject.split("/"), (Object[])StringUtils.split((String)testSubject, (char)'/'));
        }
    }

    @Test(timeout=30000L)
    public void testUnescapeString() throws Exception {
        Assert.assertEquals((Object)NULL_STR, (Object)StringUtils.unEscapeString((String)NULL_STR));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.unEscapeString((String)EMPTY_STR));
        Assert.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)StringUtils.unEscapeString((String)STR_WO_SPECIAL_CHARS));
        try {
            StringUtils.unEscapeString((String)STR_WITH_COMMA);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)STR_WITH_COMMA, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_COMMA));
        try {
            StringUtils.unEscapeString((String)STR_WITH_ESCAPE);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)STR_WITH_ESCAPE, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_ESCAPE));
        try {
            StringUtils.unEscapeString((String)STR_WITH_BOTH2);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)STR_WITH_BOTH2, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_BOTH2));
    }

    @Test(timeout=30000L)
    public void testTraditionalBinaryPrefix() throws Exception {
        String[] symbol = new String[]{"k", "m", "g", "t", "p", "e"};
        long m = 1024L;
        for (String s : symbol) {
            Assert.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(0 + s)));
            Assert.assertEquals((long)m, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(1 + s)));
            m *= 1024L;
        }
        Assert.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"0"));
        Assert.assertEquals((long)1024L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"1k"));
        Assert.assertEquals((long)-1024L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1k"));
        Assert.assertEquals((long)1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"1230K"));
        Assert.assertEquals((long)-1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1230K"));
        Assert.assertEquals((long)0x6400000L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"100m"));
        Assert.assertEquals((long)-104857600L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-100M"));
        Assert.assertEquals((long)956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"891g"));
        Assert.assertEquals((long)-956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-891G"));
        Assert.assertEquals((long)501377302265856L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"456t"));
        Assert.assertEquals((long)-501377302265856L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-456T"));
        Assert.assertEquals((long)0x28000000000000L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"10p"));
        Assert.assertEquals((long)-11258999068426240L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-10P"));
        Assert.assertEquals((long)0x1000000000000000L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"1e"));
        Assert.assertEquals((long)-1152921504606846976L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1E"));
        String tooLargeNumStr = "10e";
        try {
            StringUtils.TraditionalBinaryPrefix.string2long((String)tooLargeNumStr);
            Assert.fail((String)("Test passed for a number " + tooLargeNumStr + " too large"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)(tooLargeNumStr + " does not fit in a Long"), (Object)e.getMessage());
        }
        String tooSmallNumStr = "-10e";
        try {
            StringUtils.TraditionalBinaryPrefix.string2long((String)tooSmallNumStr);
            Assert.fail((String)("Test passed for a number " + tooSmallNumStr + " too small"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)(tooSmallNumStr + " does not fit in a Long"), (Object)e.getMessage());
        }
        String invalidFormatNumStr = "10kb";
        char invalidPrefix = 'b';
        try {
            StringUtils.TraditionalBinaryPrefix.string2long((String)invalidFormatNumStr);
            Assert.fail((String)("Test passed for a number " + invalidFormatNumStr + " has invalid format"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Invalid size prefix '" + invalidPrefix + "' in '" + invalidFormatNumStr + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)"), (Object)e.getMessage());
        }
        Assert.assertEquals((Object)"0", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0L, null, (int)2));
        for (int decimalPlace = 0; decimalPlace < 2; ++decimalPlace) {
            int n = 1;
            while ((long)n < StringUtils.TraditionalBinaryPrefix.KILO.value) {
                Assert.assertEquals((Object)(n + EMPTY_STR), (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace));
                Assert.assertEquals((Object)(-n + EMPTY_STR), (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)(-n), null, (int)decimalPlace));
                ++n;
            }
            Assert.assertEquals((Object)"1 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)1024L, null, (int)decimalPlace));
            Assert.assertEquals((Object)"-1 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)-1024L, null, (int)decimalPlace));
        }
        Assert.assertEquals((Object)"8.00 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)Long.MAX_VALUE, null, (int)2));
        Assert.assertEquals((Object)"8.00 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0x7FFFFFFFFFFFFFFEL, null, (int)2));
        Assert.assertEquals((Object)"-8 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)Long.MIN_VALUE, null, (int)2));
        Assert.assertEquals((Object)"-8.00 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)-9223372036854775807L, null, (int)2));
        String[] zeros = new String[]{" ", ".0 ", ".00 "};
        for (int decimalPlace = 0; decimalPlace < zeros.length; ++decimalPlace) {
            String trailingZeros = zeros[decimalPlace];
            for (int e = 11; e < 63; ++e) {
                StringUtils.TraditionalBinaryPrefix p = StringUtils.TraditionalBinaryPrefix.values()[e / 10 - 1];
                long n = 1L << e;
                String expected = n / p.value + " " + p.symbol;
                Assert.assertEquals((String)("n=" + n), (Object)expected, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)2));
                n = (1L << e) + 1L;
                expected = n / p.value + trailingZeros + p.symbol;
                Assert.assertEquals((String)("n=" + n), (Object)expected, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace));
                n = (1L << e) - 1L;
                expected = (n + 1L) / p.value + trailingZeros + p.symbol;
                Assert.assertEquals((String)("n=" + n), (Object)expected, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace));
            }
        }
        Assert.assertEquals((Object)"1.50 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)1536L, null, (int)2));
        Assert.assertEquals((Object)"1.5 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)1536L, null, (int)1));
        Assert.assertEquals((Object)"1.50 M", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0x180000L, null, (int)2));
        Assert.assertEquals((Object)"2 M", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0x180000L, null, (int)0));
        Assert.assertEquals((Object)"3 G", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0xC0000000L, null, (int)2));
        Assert.assertEquals((Object)"0 B", (Object)StringUtils.byteDesc((long)0L));
        Assert.assertEquals((Object)"-100 B", (Object)StringUtils.byteDesc((long)-100L));
        Assert.assertEquals((Object)"1 KB", (Object)StringUtils.byteDesc((long)1024L));
        Assert.assertEquals((Object)"1.50 KB", (Object)StringUtils.byteDesc((long)1536L));
        Assert.assertEquals((Object)"1.50 MB", (Object)StringUtils.byteDesc((long)0x180000L));
        Assert.assertEquals((Object)"3 GB", (Object)StringUtils.byteDesc((long)0xC0000000L));
        Assert.assertEquals((Object)"10%", (Object)StringUtils.formatPercent((double)0.1, (int)0));
        Assert.assertEquals((Object)"10.0%", (Object)StringUtils.formatPercent((double)0.1, (int)1));
        Assert.assertEquals((Object)"10.00%", (Object)StringUtils.formatPercent((double)0.1, (int)2));
        Assert.assertEquals((Object)"1%", (Object)StringUtils.formatPercent((double)0.00543, (int)0));
        Assert.assertEquals((Object)"0.5%", (Object)StringUtils.formatPercent((double)0.00543, (int)1));
        Assert.assertEquals((Object)"0.54%", (Object)StringUtils.formatPercent((double)0.00543, (int)2));
        Assert.assertEquals((Object)"0.543%", (Object)StringUtils.formatPercent((double)0.00543, (int)3));
        Assert.assertEquals((Object)"0.5430%", (Object)StringUtils.formatPercent((double)0.00543, (int)4));
    }

    @Test(timeout=30000L)
    public void testJoin() {
        ArrayList<String> s = new ArrayList<String>();
        s.add("a");
        s.add("b");
        s.add("c");
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.join((CharSequence)":", s.subList(0, 0)));
        Assert.assertEquals((Object)"a", (Object)StringUtils.join((CharSequence)":", s.subList(0, 1)));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.join((char)':', s.subList(0, 0)));
        Assert.assertEquals((Object)"a", (Object)StringUtils.join((char)':', s.subList(0, 1)));
        Assert.assertEquals((Object)"a:b", (Object)StringUtils.join((CharSequence)":", s.subList(0, 2)));
        Assert.assertEquals((Object)"a:b:c", (Object)StringUtils.join((CharSequence)":", s.subList(0, 3)));
        Assert.assertEquals((Object)"a:b", (Object)StringUtils.join((char)':', s.subList(0, 2)));
        Assert.assertEquals((Object)"a:b:c", (Object)StringUtils.join((char)':', s.subList(0, 3)));
    }

    @Test(timeout=30000L)
    public void testGetTrimmedStrings() throws Exception {
        String compactDirList = "/spindle1/hdfs,/spindle2/hdfs,/spindle3/hdfs";
        String spacedDirList = "/spindle1/hdfs, /spindle2/hdfs, /spindle3/hdfs";
        String pathologicalDirList1 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs ";
        String pathologicalDirList2 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs , ";
        String emptyList1 = EMPTY_STR;
        String emptyList2 = "   ";
        Object[] expectedArray = new String[]{"/spindle1/hdfs", "/spindle2/hdfs", "/spindle3/hdfs"};
        Object[] emptyArray = new String[]{};
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)compactDirList));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)spacedDirList));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList1));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList2));
        Assert.assertArrayEquals((Object[])emptyArray, (Object[])StringUtils.getTrimmedStrings((String)emptyList1));
        Object[] estring = StringUtils.getTrimmedStrings((String)emptyList2);
        Assert.assertArrayEquals((Object[])emptyArray, (Object[])estring);
    }

    @Test(timeout=30000L)
    public void testCamelize() {
        Assert.assertEquals((Object)"Map", (Object)StringUtils.camelize((String)"MAP"));
        Assert.assertEquals((Object)"JobSetup", (Object)StringUtils.camelize((String)"JOB_SETUP"));
        Assert.assertEquals((Object)"SomeStuff", (Object)StringUtils.camelize((String)"some_stuff"));
        Assert.assertEquals((Object)"Aa", (Object)StringUtils.camelize((String)"aA"));
        Assert.assertEquals((Object)"Bb", (Object)StringUtils.camelize((String)"bB"));
        Assert.assertEquals((Object)"Cc", (Object)StringUtils.camelize((String)"cC"));
        Assert.assertEquals((Object)"Dd", (Object)StringUtils.camelize((String)"dD"));
        Assert.assertEquals((Object)"Ee", (Object)StringUtils.camelize((String)"eE"));
        Assert.assertEquals((Object)"Ff", (Object)StringUtils.camelize((String)"fF"));
        Assert.assertEquals((Object)"Gg", (Object)StringUtils.camelize((String)"gG"));
        Assert.assertEquals((Object)"Hh", (Object)StringUtils.camelize((String)"hH"));
        Assert.assertEquals((Object)"Ii", (Object)StringUtils.camelize((String)"iI"));
        Assert.assertEquals((Object)"Jj", (Object)StringUtils.camelize((String)"jJ"));
        Assert.assertEquals((Object)"Kk", (Object)StringUtils.camelize((String)"kK"));
        Assert.assertEquals((Object)"Ll", (Object)StringUtils.camelize((String)"lL"));
        Assert.assertEquals((Object)"Mm", (Object)StringUtils.camelize((String)"mM"));
        Assert.assertEquals((Object)"Nn", (Object)StringUtils.camelize((String)"nN"));
        Assert.assertEquals((Object)"Oo", (Object)StringUtils.camelize((String)"oO"));
        Assert.assertEquals((Object)"Pp", (Object)StringUtils.camelize((String)"pP"));
        Assert.assertEquals((Object)"Qq", (Object)StringUtils.camelize((String)"qQ"));
        Assert.assertEquals((Object)"Rr", (Object)StringUtils.camelize((String)"rR"));
        Assert.assertEquals((Object)"Ss", (Object)StringUtils.camelize((String)"sS"));
        Assert.assertEquals((Object)"Tt", (Object)StringUtils.camelize((String)"tT"));
        Assert.assertEquals((Object)"Uu", (Object)StringUtils.camelize((String)"uU"));
        Assert.assertEquals((Object)"Vv", (Object)StringUtils.camelize((String)"vV"));
        Assert.assertEquals((Object)"Ww", (Object)StringUtils.camelize((String)"wW"));
        Assert.assertEquals((Object)"Xx", (Object)StringUtils.camelize((String)"xX"));
        Assert.assertEquals((Object)"Yy", (Object)StringUtils.camelize((String)"yY"));
        Assert.assertEquals((Object)"Zz", (Object)StringUtils.camelize((String)"zZ"));
    }

    @Test(timeout=30000L)
    public void testStringToURI() {
        String[] str = new String[]{"file://"};
        try {
            StringUtils.stringToURI((String[])str);
            Assert.fail((String)"Ignoring URISyntaxException while creating URI from string file://");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)"Failed to create uri for file://", (Object)iae.getMessage());
        }
    }

    @Test(timeout=30000L)
    public void testSimpleHostName() {
        Assert.assertEquals((String)"Should return hostname when FQDN is specified", (Object)"hadoop01", (Object)StringUtils.simpleHostname((String)"hadoop01.domain.com"));
        Assert.assertEquals((String)"Should return hostname when only hostname is specified", (Object)"hadoop01", (Object)StringUtils.simpleHostname((String)"hadoop01"));
        Assert.assertEquals((String)"Should not truncate when IP address is passed", (Object)"10.10.5.68", (Object)StringUtils.simpleHostname((String)"10.10.5.68"));
    }

    @Test(timeout=5000L)
    public void testReplaceTokensShellEnvVars() {
        Pattern pattern = StringUtils.SHELL_ENV_VAR_PATTERN;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("FOO", "one");
        replacements.put("BAZ", "two");
        replacements.put("NUMBERS123", "one-two-three");
        replacements.put("UNDER_SCORES", "___");
        Assert.assertEquals((Object)"one", (Object)StringUtils.replaceTokens((String)"$FOO", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)"two", (Object)StringUtils.replaceTokens((String)"$BAZ", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)"$BAR", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)EMPTY_STR, (Pattern)pattern, replacements));
        Assert.assertEquals((Object)"one-two-three", (Object)StringUtils.replaceTokens((String)"$NUMBERS123", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)"___", (Object)StringUtils.replaceTokens((String)"$UNDER_SCORES", (Pattern)pattern, replacements));
    }

    @Test(timeout=5000L)
    public void testReplaceTokensWinEnvVars() {
        Pattern pattern = StringUtils.WIN_ENV_VAR_PATTERN;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("foo", "zoo");
        replacements.put("baz", "zaz");
        Assert.assertEquals((Object)"zoo", (Object)StringUtils.replaceTokens((String)"%foo%", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)"zaz", (Object)StringUtils.replaceTokens((String)"%baz%", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)"%bar%", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)EMPTY_STR, (Pattern)pattern, replacements));
        Assert.assertEquals((Object)"zoo__zaz", (Object)StringUtils.replaceTokens((String)"%foo%_%bar%_%baz%", (Pattern)pattern, replacements));
        Assert.assertEquals((Object)"begin zoo__zaz end", (Object)StringUtils.replaceTokens((String)"begin %foo%_%bar%_%baz% end", (Pattern)pattern, replacements));
    }

    @Test
    public void testGetUniqueNonEmptyTrimmedStrings() {
        String TO_SPLIT = ",foo, bar,baz,,blah,blah,bar,";
        Collection col = StringUtils.getTrimmedStringCollection((String)",foo, bar,baz,,blah,blah,bar,");
        Assert.assertEquals((long)4L, (long)col.size());
        Assert.assertTrue((boolean)col.containsAll(Arrays.asList("foo", "bar", "baz", "blah")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLowerAndUpperStrings() {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr", "TR"));
            String upperStr = "TITLE";
            String lowerStr = "title";
            Assert.assertNotEquals((Object)lowerStr, (Object)upperStr.toLowerCase());
            Assert.assertNotEquals((Object)upperStr, (Object)lowerStr.toUpperCase());
            Assert.assertEquals((Object)lowerStr, (Object)StringUtils.toLowerCase((String)upperStr));
            Assert.assertEquals((Object)upperStr, (Object)StringUtils.toUpperCase((String)lowerStr));
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((String)upperStr, (String)lowerStr));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void testGetFormattedTimeWithDiff() throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        for (int i = 0; i < 10; ++i) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        cyclicBarrier.await();
                    }
                    catch (InterruptedException | BrokenBarrierException exception) {
                        // empty catch block
                    }
                    long end = System.currentTimeMillis();
                    long start = end - 30000L;
                    String formattedTime1 = StringUtils.getFormattedTimeWithDiff((FastDateFormat)FAST_DATE_FORMAT, (long)start, (long)end);
                    String formattedTime2 = StringUtils.getFormattedTimeWithDiff((FastDateFormat)FAST_DATE_FORMAT, (long)start, (long)end);
                    Assert.assertTrue((String)"Method returned inconsistent results indicative of a race condition", (boolean)formattedTime1.equals(formattedTime2));
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(50L, TimeUnit.SECONDS);
    }

    @Test
    public void testCreateStartupShutdownMessage() {
        String msg = StringUtils.createStartupShutdownMessage((String)this.getClass().getName(), (String)"test.host", null);
        Assert.assertTrue((boolean)msg.startsWith("STARTUP_MSG:"));
    }

    public static void main(String[] args) {
        String TO_SPLIT = "foo,bar,baz,blah,blah";
        for (boolean useOurs : new boolean[]{false, true}) {
            for (int outer = 0; outer < 10; ++outer) {
                long st = System.nanoTime();
                int components = 0;
                for (int inner = 0; inner < 1000000; ++inner) {
                    String[] res = useOurs ? StringUtils.split((String)"foo,bar,baz,blah,blah", (char)',') : "foo,bar,baz,blah,blah".split(",");
                    components += res.length;
                }
                long et = System.nanoTime();
                if (outer <= 3) continue;
                System.out.println((useOurs ? "StringUtils impl" : "Java impl") + " #" + outer + ":" + (et - st) / 1000000L + "ms, components=" + components);
            }
        }
    }
}

