/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver.log;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleFactory;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.server.logger.LogEvents;
import org.apache.accumulo.server.logger.LogFileKey;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.tabletserver.TabletMutations;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class DfsLogger {
    static final String LOG_FILE_HEADER_V2 = "--- Log File Header (v2) ---";
    private static Logger log = Logger.getLogger(DfsLogger.class);
    private final LinkedBlockingQueue<LogWork> workQueue = new LinkedBlockingQueue();
    private final Object closeLock = new Object();
    private static final LogWork CLOSED_MARKER = new LogWork(null, null);
    private static final LogFileValue EMPTY = new LogFileValue();
    private boolean closed = false;
    private final ServerResources conf;
    private FSDataOutputStream logFile;
    private DataOutputStream encryptingLogFile = null;
    private Method sync;
    private Path logPath;
    private String logger;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DfsLogger) {
            return this.getFileName().equals(((DfsLogger)obj).getFileName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFileName().hashCode();
    }

    public DfsLogger(ServerResources conf) throws IOException {
        this.conf = conf;
    }

    public DfsLogger(ServerResources conf, String logger, String filename) throws IOException {
        this.conf = conf;
        this.logger = logger;
        this.logPath = new Path(Constants.getWalDirectory((AccumuloConfiguration)conf.getConfiguration()), filename);
    }

    public static FSDataInputStream readHeader(FileSystem fs, Path path, Map<String, String> opts) throws IOException {
        FSDataInputStream file = fs.open(path);
        try {
            byte[] magic = LOG_FILE_HEADER_V2.getBytes();
            byte[] buffer = new byte[magic.length];
            file.readFully(buffer);
            if (Arrays.equals(buffer, magic)) {
                int count = file.readInt();
                for (int i = 0; i < count; ++i) {
                    String key = file.readUTF();
                    String value = file.readUTF();
                    opts.put(key, value);
                }
            } else {
                file.seek(0L);
                return file;
            }
            return file;
        }
        catch (IOException ex) {
            file.seek(0L);
            return file;
        }
    }

    public synchronized void open(String address) throws IOException {
        String filename = UUID.randomUUID().toString();
        this.logger = StringUtil.join(Arrays.asList(address.split(":")), (String)"+");
        log.debug((Object)"DfsLogger.open() begin");
        this.logPath = new Path(Constants.getWalDirectory((AccumuloConfiguration)this.conf.getConfiguration()) + "/" + this.logger + "/" + filename);
        try {
            Object key2;
            long blockSize;
            FileSystem fs = this.conf.getFileSystem();
            short replication = (short)this.conf.getConfiguration().getCount(Property.TSERV_WAL_REPLICATION);
            if (replication == 0) {
                replication = fs.getDefaultReplication();
            }
            if ((blockSize = this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_WAL_BLOCKSIZE)) == 0L) {
                blockSize = (long)((double)this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_WALOG_MAX_SIZE) * 1.1);
            }
            int checkSum = fs.getConf().getInt("io.bytes.per.checksum", 512);
            blockSize -= blockSize % (long)checkSum;
            blockSize = Math.max(blockSize, (long)checkSum);
            this.logFile = this.conf.getConfiguration().getBoolean(Property.TSERV_WAL_SYNC) ? this.create(fs, this.logPath, true, fs.getConf().getInt("io.file.buffer.size", 4096), replication, blockSize) : fs.create(this.logPath, true, fs.getConf().getInt("io.file.buffer.size", 4096), replication, blockSize);
            try {
                this.sync = this.logFile.getClass().getMethod("sync", new Class[0]);
                try {
                    this.sync = this.logFile.getClass().getMethod("hsync", new Class[0]);
                }
                catch (NoSuchMethodException ex) {}
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)this.conf.getConfiguration().get(Property.CRYPTO_MODULE_CLASS));
            this.logFile.write(LOG_FILE_HEADER_V2.getBytes());
            Map cryptoOpts = this.conf.getConfiguration().getAllPropertiesWithPrefix(Property.CRYPTO_PREFIX);
            this.logFile.writeInt(cryptoOpts.size());
            for (Object key2 : cryptoOpts.keySet()) {
                this.logFile.writeUTF((String)key2);
                this.logFile.writeUTF((String)cryptoOpts.get(key2));
            }
            OutputStream encipheringOutputStream = cryptoModule.getEncryptingOutputStream((OutputStream)this.logFile, cryptoOpts);
            this.encryptingLogFile = encipheringOutputStream == this.logFile ? this.logFile : new DataOutputStream(encipheringOutputStream);
            key2 = new LogFileKey();
            ((LogFileKey)key2).event = LogEvents.OPEN;
            ((LogFileKey)key2).tserverSession = filename;
            ((LogFileKey)key2).filename = filename;
            this.write((LogFileKey)key2, EMPTY);
            this.logFile.sync();
            log.debug((Object)("Got new write-ahead log: " + this));
        }
        catch (IOException ex) {
            if (this.logFile != null) {
                this.logFile.close();
            }
            this.logFile = null;
            throw ex;
        }
        Daemon t = new Daemon((Runnable)new LogSyncingTask());
        t.setName("Accumulo WALog thread " + this.toString());
        t.start();
    }

    private FSDataOutputStream create(FileSystem fs, Path logPath, boolean b, int buffersize, short replication, long blockSize) throws IOException {
        try {
            Class<?> createFlags = Class.forName("org.apache.hadoop.fs.CreateFlag");
            ArrayList<Enum> flags = new ArrayList<Enum>();
            if (createFlags.isEnum()) {
                for (Object constant : createFlags.getEnumConstants()) {
                    if (constant.toString().equals("SYNC_BLOCK")) {
                        flags.add((Enum)constant);
                        log.debug((Object)("Found synch enum " + constant));
                    }
                    if (!constant.toString().equals("CREATE")) continue;
                    flags.add((Enum)constant);
                    log.debug((Object)("Found CREATE enum " + constant));
                }
            }
            Object set = EnumSet.class.getMethod("of", Enum.class, Enum.class).invoke(null, flags.get(0), flags.get(1));
            log.debug((Object)("CreateFlag set: " + set));
            if (fs instanceof TraceFileSystem) {
                fs = ((TraceFileSystem)fs).getImplementation();
            }
            Method create = fs.getClass().getMethod("create", Path.class, FsPermission.class, EnumSet.class, Integer.TYPE, Short.TYPE, Long.TYPE, Progressable.class);
            log.debug((Object)("creating " + logPath + " with SYNCH_BLOCK flag"));
            return (FSDataOutputStream)create.invoke((Object)fs, logPath, FsPermission.getDefault(), set, buffersize, replication, blockSize, null);
        }
        catch (ClassNotFoundException ex) {
            return fs.create(logPath, b, buffersize, replication, blockSize);
        }
        catch (Exception ex) {
            log.debug((Object)ex, (Throwable)ex);
            return fs.create(logPath, b, buffersize, replication, blockSize);
        }
    }

    public String toString() {
        return this.getLogger() + "/" + this.getFileName();
    }

    public String getLogger() {
        return this.logger;
    }

    public String getFileName() {
        return this.logPath.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.workQueue.add(CLOSED_MARKER);
            while (!this.workQueue.isEmpty()) {
                try {
                    this.closeLock.wait();
                }
                catch (InterruptedException e) {
                    log.info((Object)"Interrupted");
                }
            }
        }
        if (this.logFile != null) {
            try {
                this.logFile.close();
            }
            catch (IOException ex) {
                log.error((Object)ex);
                throw new LogClosedException();
            }
        }
    }

    public synchronized void defineTablet(int seq, int tid, KeyExtent tablet) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.DEFINE_TABLET;
        key.seq = seq;
        key.tid = tid;
        key.tablet = tablet;
        try {
            this.write(key, EMPTY);
            this.logFile.sync();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            throw ex;
        }
    }

    private synchronized void write(LogFileKey key, LogFileValue value) throws IOException {
        key.write(this.encryptingLogFile);
        value.write(this.encryptingLogFile);
    }

    public LoggerOperation log(int seq, int tid, Mutation mutation) throws IOException {
        return this.logManyTablets(Collections.singletonList(new TabletMutations(tid, seq, Collections.singletonList(mutation))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerOperation logManyTablets(List<TabletMutations> mutations) throws IOException {
        LogWork work = new LogWork(mutations, new CountDownLatch(1));
        Object object = this;
        synchronized (object) {
            try {
                for (TabletMutations tabletMutations : mutations) {
                    LogFileKey key = new LogFileKey();
                    key.event = LogEvents.MANY_MUTATIONS;
                    key.seq = tabletMutations.getSeq();
                    key.tid = tabletMutations.getTid();
                    LogFileValue value = new LogFileValue();
                    value.mutations = tabletMutations.getMutations();
                    this.write(key, value);
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                work.exception = e;
            }
        }
        object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new LogClosedException();
            }
            this.workQueue.add(work);
        }
        return new LoggerOperation(work);
    }

    public synchronized void minorCompactionFinished(int seq, int tid, String fqfn) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.COMPACTION_FINISH;
        key.seq = seq;
        key.tid = tid;
        try {
            this.write(key, EMPTY);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            throw ex;
        }
    }

    public synchronized void minorCompactionStarted(int seq, int tid, String fqfn) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.COMPACTION_START;
        key.seq = seq;
        key.tid = tid;
        key.filename = fqfn;
        try {
            this.write(key, EMPTY);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            throw ex;
        }
    }

    public static class LoggerOperation {
        private final LogWork work;

        public LoggerOperation(LogWork work) {
            this.work = work;
        }

        public void await() throws IOException {
            try {
                this.work.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.work.exception != null) {
                if (this.work.exception instanceof IOException) {
                    throw (IOException)this.work.exception;
                }
                if (this.work.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.work.exception;
                }
                throw new RuntimeException(this.work.exception);
            }
        }
    }

    static class LogWork {
        List<TabletMutations> mutations;
        CountDownLatch latch;
        volatile Exception exception;

        public LogWork(List<TabletMutations> mutations, CountDownLatch latch) {
            this.mutations = mutations;
            this.latch = latch;
        }
    }

    private class LogSyncingTask
    implements Runnable {
        private LogSyncingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList work = new ArrayList();
            while (true) {
                work.clear();
                try {
                    work.add(DfsLogger.this.workQueue.take());
                }
                catch (InterruptedException ex) {
                    continue;
                }
                DfsLogger.this.workQueue.drainTo(work);
                Object ex = DfsLogger.this.closeLock;
                synchronized (ex) {
                    if (!DfsLogger.this.closed) {
                        try {
                            DfsLogger.this.sync.invoke((Object)DfsLogger.this.logFile, new Object[0]);
                        }
                        catch (Exception ex2) {
                            log.warn((Object)("Exception syncing " + ex2));
                            for (LogWork logWork : work) {
                                logWork.exception = ex2;
                            }
                        }
                    } else {
                        for (LogWork logWork : work) {
                            logWork.exception = new LogClosedException();
                        }
                    }
                }
                boolean sawClosedMarker = false;
                for (LogWork logWork : work) {
                    if (logWork == CLOSED_MARKER) {
                        sawClosedMarker = true;
                        continue;
                    }
                    logWork.latch.countDown();
                }
                if (sawClosedMarker) break;
            }
            Object object = DfsLogger.this.closeLock;
            synchronized (object) {
                DfsLogger.this.closeLock.notifyAll();
            }
        }
    }

    public static interface ServerResources {
        public AccumuloConfiguration getConfiguration();

        public FileSystem getFileSystem();

        public Set<TServerInstance> getCurrentTServers();
    }

    public static class LogClosedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public LogClosedException() {
            super("LogClosed");
        }
    }
}

