/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.bzip2r;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigFileInputFormat;
import org.apache.tools.bzip2r.CBZip2InputStream;

public class Bzip2TextInputFormat
extends PigFileInputFormat {
    public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new BZip2LineRecordReader(context.getConfiguration(), (FileSplit)split);
    }

    private static class BZip2LineRecordReader
    extends RecordReader<LongWritable, Text> {
        private long start;
        private long end;
        private long pos;
        private CBZip2InputStream in;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream(256);
        private boolean CRFollowedByNonLF = false;
        private byte nonLFChar;
        private TextStuffer bridge = new TextStuffer();
        private LongWritable key = new LongWritable();
        private Text value = new Text();

        public BZip2LineRecordReader(Configuration job, FileSplit split) throws IOException {
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem(job);
            FSDataInputStream fileIn = fs.open(split.getPath());
            fileIn.seek(this.start);
            this.in = new CBZip2InputStream(fileIn, 9, this.end);
            if (this.start != 0L) {
                this.readLine(this.in, null);
                this.start = this.in.getPos();
            }
            this.pos = this.in.getPos();
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public Text createValue() {
            return new Text();
        }

        private long readLine(InputStream in, OutputStream out) throws IOException {
            long bytes = 0L;
            while (true) {
                int b = -1;
                if (this.CRFollowedByNonLF) {
                    b = this.nonLFChar;
                    this.CRFollowedByNonLF = false;
                } else {
                    b = in.read();
                }
                if (b == -1) break;
                ++bytes;
                byte c = (byte)b;
                if (c == 10) break;
                if (c == 13) {
                    byte nextC = (byte)in.read();
                    if (nextC != 10) {
                        this.CRFollowedByNonLF = true;
                        this.nonLFChar = nextC;
                        break;
                    }
                    ++bytes;
                    break;
                }
                if (out == null) continue;
                out.write(c);
            }
            return bytes;
        }

        public boolean next(LongWritable key, Text value) throws IOException {
            if (this.pos > this.end) {
                return false;
            }
            key.set(this.pos);
            this.buffer.reset();
            long bytesRead = this.readLine(this.in, this.buffer);
            if (bytesRead == 0L) {
                return false;
            }
            this.pos = this.in.getPos();
            if (this.CRFollowedByNonLF) {
                --this.pos;
            }
            this.bridge.target = value;
            this.buffer.writeTo(this.bridge);
            return true;
        }

        public float getProgress() {
            if (this.start == this.end) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
        }

        public long getPos() throws IOException {
            return this.pos;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.next(this.key, this.value);
        }

        private static class TextStuffer
        extends OutputStream {
            public Text target;

            private TextStuffer() {
            }

            @Override
            public void write(int b) {
                throw new UnsupportedOperationException("write(byte) not supported");
            }

            @Override
            public void write(byte[] data, int offset, int len) throws IOException {
                this.target.clear();
                this.target.set(data, offset, len);
            }
        }
    }
}

