/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.trace.instrument.Tracer;

public class SecurityOperationsImpl
implements SecurityOperations {
    private Instance instance;
    private TCredentials credentials;

    private void execute(ClientExec<ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            ServerClient.executeRaw(this.instance, exec);
        }
        catch (ThriftTableOperationException ttoe) {
            if (ttoe.getType() == TableOperationExceptionType.NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            throw new AccumuloException((Throwable)((Object)ttoe));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    private <T> T execute(ClientExecReturn<T, ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return ServerClient.executeRaw(this.instance, exec);
        }
        catch (ThriftTableOperationException ttoe) {
            if (ttoe.getType() == TableOperationExceptionType.NOTFOUND) {
                throw new AccumuloSecurityException(null, SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            throw new AccumuloException((Throwable)((Object)ttoe));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public SecurityOperationsImpl(Instance instance, TCredentials credentials) {
        ArgumentChecker.notNull(instance, credentials);
        this.instance = instance;
        this.credentials = credentials;
    }

    @Override
    @Deprecated
    public void createUser(String user, byte[] password, Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        this.createLocalUser(user, new PasswordToken(password));
        this.changeUserAuthorizations(user, authorizations);
    }

    @Override
    public void createLocalUser(final String principal, final PasswordToken password) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, password);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.createLocalUser(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, ByteBuffer.wrap(password.getPassword()));
            }
        });
    }

    @Override
    @Deprecated
    public void dropUser(String user) throws AccumuloException, AccumuloSecurityException {
        this.dropLocalUser(user);
    }

    @Override
    public void dropLocalUser(final String principal) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.dropLocalUser(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal);
            }
        });
    }

    @Override
    @Deprecated
    public boolean authenticateUser(String user, byte[] password) throws AccumuloException, AccumuloSecurityException {
        return this.authenticateUser(user, new PasswordToken(password));
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, token);
        final TCredentials toAuth = CredentialHelper.create(principal, token, this.instance.getInstanceID());
        return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.authenticateUser(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, toAuth);
            }
        });
    }

    @Override
    @Deprecated
    public void changeUserPassword(String user, byte[] password) throws AccumuloException, AccumuloSecurityException {
        this.changeLocalUserPassword(user, new PasswordToken(password));
    }

    @Override
    public void changeLocalUserPassword(final String principal, final PasswordToken token) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, token);
        TCredentials toChange = CredentialHelper.create(principal, token, this.instance.getInstanceID());
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.changeLocalUserPassword(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, ByteBuffer.wrap(token.getPassword()));
            }
        });
        if (this.credentials.principal.equals(principal)) {
            this.credentials = toChange;
        }
    }

    @Override
    public void changeUserAuthorizations(final String principal, final Authorizations authorizations) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, authorizations);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.changeAuthorizations(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, ByteBufferUtil.toByteBuffers(authorizations.getAuthorizations()));
            }
        });
    }

    @Override
    public Authorizations getUserAuthorizations(final String principal) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal);
        return this.execute(new ClientExecReturn<Authorizations, ClientService.Client>(){

            @Override
            public Authorizations execute(ClientService.Client client) throws Exception {
                return new Authorizations(client.getUserAuthorizations(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal));
            }
        });
    }

    @Override
    public boolean hasSystemPermission(final String principal, final SystemPermission perm) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, (Object)perm);
        return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.hasSystemPermission(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, perm.getId());
            }
        });
    }

    @Override
    public boolean hasTablePermission(final String principal, final String table, final TablePermission perm) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, table, (Object)perm);
        return this.execute(new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.hasTablePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, table, perm.getId());
            }
        });
    }

    @Override
    public void grantSystemPermission(final String principal, final SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, (Object)permission);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.grantSystemPermission(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, permission.getId());
            }
        });
    }

    @Override
    public void grantTablePermission(final String principal, final String table, final TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, table, (Object)permission);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.grantTablePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, table, permission.getId());
            }
        });
    }

    @Override
    public void revokeSystemPermission(final String principal, final SystemPermission permission) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, (Object)permission);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.revokeSystemPermission(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, permission.getId());
            }
        });
    }

    @Override
    public void revokeTablePermission(final String principal, final String table, final TablePermission permission) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(principal, table, (Object)permission);
        this.execute(new ClientExec<ClientService.Client>(){

            @Override
            public void execute(ClientService.Client client) throws Exception {
                client.revokeTablePermission(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials, principal, table, permission.getId());
            }
        });
    }

    @Override
    @Deprecated
    public Set<String> listUsers() throws AccumuloException, AccumuloSecurityException {
        return this.listLocalUsers();
    }

    @Override
    public Set<String> listLocalUsers() throws AccumuloException, AccumuloSecurityException {
        return this.execute(new ClientExecReturn<Set<String>, ClientService.Client>(){

            @Override
            public Set<String> execute(ClientService.Client client) throws Exception {
                return client.listLocalUsers(Tracer.traceInfo(), SecurityOperationsImpl.this.credentials);
            }
        });
    }
}

