import { Config, DomQuery, DQ } from "mona-dish";
/**
 * encodes a given form data into a url encoded string
 * @param formData the form data config object
 * @param paramsMapper the params mapper
 * @param defaultStr a default string if nothing comes out of it
 */
export declare function encodeFormData(formData: Config, paramsMapper?: (inStr: any, inVal: any) => any[], defaultStr?: string): string;
/**
 * splits and decodes encoded values into strings containing of key=value
 * @param encoded encoded string
 */
export declare function decodeEncodedValues(encoded: string): string[][];
/**
 * gets all the input files and their corresponding file objects
 * @param dataSource
 */
export declare function resolveFiles(dataSource: DQ): [string, File][];
export declare function fixEmptyParameters(keyVal: any[]): [string, any];
/**
 * gets all the inputs under the form parentItem
 * as array
 * @param parentItem
 */
export declare function getFormInputsAsArr(parentItem: DomQuery): string[][] | [string, File][];
