package org.apache.logging.log4j.spring.boot.plugins;

import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginService;

public class Log4jPlugins extends PluginService {

  private static final PluginEntry[] ENTRIES = new PluginEntry[] {
    PluginEntry.builder()
      .setKey("spring")
      .setClassName("org.apache.logging.log4j.spring.boot.SpringLookup")
      .setName("spring")
      .setNamespace("Lookup")
      .get(),
    PluginEntry.builder()
      .setKey("springprofile")
      .setClassName("org.apache.logging.log4j.spring.boot.SpringProfileArbiter")
      .setName("SpringProfile")
      .setNamespace("Core")
      .setElementType("Arbiter")
      .setPrintable(true)
      .setDeferChildren(true)
      .get()
    };
    @Override
    public PluginEntry[] getEntries() { return ENTRIES; }
}
