package org.apache.logging.log4j.layout.template.json.plugins;

import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginService;

public class Log4jPlugins extends PluginService {

  private static final PluginEntry[] ENTRIES = new PluginEntry[] {
    PluginEntry.builder()
      .setKey("sourceresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.SourceResolverFactory")
      .setName("SourceResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("eventadditionalfieldinterceptor")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.EventAdditionalFieldInterceptor")
      .setName("EventAdditionalFieldInterceptor")
      .setNamespace("JsonTemplateResolverInterceptor")
      .get(),
    PluginEntry.builder()
      .setKey("levelresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.LevelResolverFactory")
      .setName("LevelResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("endofbatchresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.EndOfBatchResolverFactory")
      .setName("EndOfBatchResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("exceptionresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.ExceptionResolverFactory")
      .setName("ExceptionResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("threadresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.ThreadResolverFactory")
      .setName("ThreadResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("mainmapresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.MainMapResolverFactory")
      .setName("MainMapResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("jsontemplatelayout")
      .setClassName("org.apache.logging.log4j.layout.template.json.JsonTemplateLayout")
      .setName("JsonTemplateLayout")
      .setNamespace("Core")
      .setElementType("layout")
      .get(),
    PluginEntry.builder()
      .setKey("eventtemplateadditionalfield")
      .setClassName("org.apache.logging.log4j.layout.template.json.JsonTemplateLayout$EventTemplateAdditionalField")
      .setName("EventTemplateAdditionalField")
      .setNamespace("Core")
      .setElementType("EventTemplateAdditionalField")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("mapresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.MapResolverFactory")
      .setName("MapResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("recyclerfactoryconverter")
      .setClassName("org.apache.logging.log4j.layout.template.json.util.RecyclerFactoryConverter")
      .setName("RecyclerFactoryConverter")
      .setNamespace("TypeConverter")
      .get(),
    PluginEntry.builder()
      .setKey("markerresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.MarkerResolverFactory")
      .setName("MarkerResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("timestampresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.TimestampResolverFactory")
      .setName("TimestampResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("patternresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.PatternResolverFactory")
      .setName("PatternResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("eventrootobjectkeyinterceptor")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.EventRootObjectKeyInterceptor")
      .setName("EventRootObjectKeyInterceptor")
      .setNamespace("JsonTemplateResolverInterceptor")
      .get(),
    PluginEntry.builder()
      .setKey("messageparameterresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.MessageParameterResolverFactory")
      .setName("MessageParameterResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("messageresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.MessageResolverFactory")
      .setName("MessageResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("exceptionrootcauseresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.ExceptionRootCauseResolverFactory")
      .setName("ExceptionRootCauseResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("counterresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.CounterResolverFactory")
      .setName("CounterResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("threadcontextstackresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.ThreadContextStackResolverFactory")
      .setName("ThreadContextStackResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("loggerresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.LoggerResolverFactory")
      .setName("LoggerResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("caseconverterresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.CaseConverterResolverFactory")
      .setName("CaseConverterResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get(),
    PluginEntry.builder()
      .setKey("threadcontextdataresolverfactory")
      .setClassName("org.apache.logging.log4j.layout.template.json.resolver.ThreadContextDataResolverFactory")
      .setName("ThreadContextDataResolverFactory")
      .setNamespace("JsonTemplateResolverFactory")
      .get()
    };
    @Override
    public PluginEntry[] getEntries() { return ENTRIES; }
}
