/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyKey;

public class SslConfigurationFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Lazy<SslConfiguration> SSL_CONFIGURATION = Lazy.lazy(() -> {
        PropertiesUtil props = PropertiesUtil.getProperties();
        return SslConfigurationFactory.createSslConfiguration((PropertyEnvironment)props);
    });

    static SslConfiguration createSslConfiguration(PropertyEnvironment props) {
        char[] passwordChars;
        String password;
        KeyStoreConfiguration keyStoreConfiguration = null;
        TrustStoreConfiguration trustStoreConfiguration = null;
        String location = props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_TRUST_STORE_LOCATION);
        if (location != null) {
            password = props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_TRUST_STORE_PASSWORD);
            passwordChars = null;
            if (password != null) {
                passwordChars = password.toCharArray();
            }
            try {
                trustStoreConfiguration = TrustStoreConfiguration.createKeyStoreConfiguration(location, passwordChars, props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_TRUST_STORE_PASSWORD_ENV_VAR), props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_TRUST_STORE_PASSWORD_FILE), props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_TRUST_STORE_TYPE), props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_TRUST_STORE_KEY_MANAGER_FACTORY_ALGORITHM));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to create trust store configuration due to: {} {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            }
        }
        if ((location = props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_KEY_STORE_LOCATION)) != null) {
            password = props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_KEY_STORE_PASSWORD);
            passwordChars = null;
            if (password != null) {
                passwordChars = password.toCharArray();
            }
            try {
                keyStoreConfiguration = KeyStoreConfiguration.createKeyStoreConfiguration(location, passwordChars, props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_KEY_STORE_PASSWORD_ENV_VAR), props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_KEY_STORE_PASSWORD_FILE), props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_KEY_STORE_TYPE), props.getStringProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_KEY_STORE_KEY_MANAGER_FACTORY_ALGORITHM));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to create key store configuration due to: {} {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            }
        }
        if (trustStoreConfiguration != null || keyStoreConfiguration != null) {
            boolean isVerifyHostName = props.getBooleanProperty((PropertyKey)Log4jPropertyKey.TRANSPORT_SECURITY_VERIFY_HOST_NAME, false);
            return SslConfiguration.createSSLConfiguration(null, keyStoreConfiguration, trustStoreConfiguration, isVerifyHostName);
        }
        return null;
    }

    public static SslConfiguration getSslConfiguration() {
        return (SslConfiguration)SSL_CONFIGURATION.value();
    }
}

