/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.visit;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginConfigurationVisitor
implements NodeVisitor {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Configuration configuration;

    @Inject
    public PluginConfigurationVisitor(Configuration configuration) {
        this.configuration = configuration;
    }

    public Object visitField(Field field, Node node, StringBuilder debugLog) {
        if (TypeUtil.isAssignable((Type)field.getGenericType(), this.configuration.getClass())) {
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"configuration", (Object)this.configuration, (CharSequence)", ");
            return Cast.cast((Object)this.configuration);
        }
        LOGGER.error("Field {} annotated with @PluginConfiguration is not compatible with type {}", (Object)field, this.configuration.getClass());
        return null;
    }

    public Object visitParameter(Parameter parameter, Node node, StringBuilder debugLog) {
        if (TypeUtil.isAssignable((Type)parameter.getParameterizedType(), this.configuration.getClass())) {
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"configuration", (Object)this.configuration, (CharSequence)", ");
            return Cast.cast((Object)this.configuration);
        }
        LOGGER.error("Parameter {} annotated with @PluginConfiguration is not compatible with type {}", (Object)parameter, this.configuration.getClass());
        return null;
    }
}

