/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.annotation;

import java.lang.reflect.AnnotatedElement;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.annotation.ConditionalOnPropertyKey;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.condition.Condition;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;

@Singleton
public class OnPropertyKeyCondition
implements Condition {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public boolean matches(Key<?> key, AnnotatedElement element) {
        ConditionalOnPropertyKey annotation = (ConditionalOnPropertyKey)AnnotationUtil.getLogicalAnnotation((AnnotatedElement)element, ConditionalOnPropertyKey.class);
        if (annotation == null) {
            return false;
        }
        Log4jPropertyKey propertyKey = annotation.key();
        String value = annotation.value();
        String property = PropertiesUtil.getProperties().getStringProperty((PropertyKey)propertyKey);
        boolean result = property != null && (value.isEmpty() || value.equalsIgnoreCase(property));
        LOGGER.debug("ConditionalOnPropertyKey {} for key='{}', value='{}'; property='{}'", (Object)result, (Object)propertyKey.getName(), (Object)value, (Object)property);
        return result;
    }
}

