/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.HashSet;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;

public abstract class AbstractJacksonFactory {
    protected final boolean includeStacktrace;
    protected final boolean stacktraceAsString;

    public AbstractJacksonFactory(boolean includeStacktrace, boolean stacktraceAsString) {
        this.includeStacktrace = includeStacktrace;
        this.stacktraceAsString = stacktraceAsString;
    }

    protected abstract String getPropertyNameForContextMap();

    protected abstract String getPropertyNameForTimeMillis();

    protected abstract String getPropertyNameForInstant();

    protected abstract String getPropertyNameForNanoTime();

    protected abstract String getPropertyNameForSource();

    protected abstract String getPropertyNameForStackTrace();

    protected abstract PrettyPrinter newCompactPrinter();

    protected abstract ObjectMapper newObjectMapper();

    protected abstract PrettyPrinter newPrettyPrinter();

    public ObjectWriter newWriter(boolean locationInfo, boolean properties, boolean compact, boolean includeMillis) {
        SimpleFilterProvider filters = new SimpleFilterProvider();
        HashSet<String> except = new HashSet<String>(5);
        if (!locationInfo) {
            except.add(this.getPropertyNameForSource());
        }
        if (!properties) {
            except.add(this.getPropertyNameForContextMap());
        }
        if (!this.includeStacktrace) {
            except.add(this.getPropertyNameForStackTrace());
        }
        if (includeMillis) {
            except.add(this.getPropertyNameForInstant());
        } else {
            except.add(this.getPropertyNameForTimeMillis());
        }
        except.add(this.getPropertyNameForNanoTime());
        filters.addFilter(Log4jLogEvent.class.getName(), SimpleBeanPropertyFilter.serializeAllExcept(except));
        ObjectWriter writer = this.newObjectMapper().writer(compact ? this.newCompactPrinter() : this.newPrettyPrinter());
        return writer.with((FilterProvider)filters);
    }
}

