/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kubernetes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class ContainerUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int MAXLENGTH = 65;

    public static String getContainerId() {
        try {
            File file = new File("/proc/self/cgroup");
            if (file.exists()) {
                Path path = file.toPath();
                String id = Files.lines(path).map(ContainerUtil::getContainerId).filter(Objects::nonNull).findFirst().orElse(null);
                LOGGER.debug("Found container id {}", (Object)id);
                return id;
            }
            LOGGER.warn("Unable to access container information");
        }
        catch (IOException ioe) {
            LOGGER.warn("Error obtaining container id: {}", (Object)ioe.getMessage());
        }
        return null;
    }

    private static String getContainerId(String line) {
        if (line.contains("/kubepods")) {
            int i = line.lastIndexOf(47);
            if (i < 0) {
                return null;
            }
            if ((i = (line = line.substring(i + 1)).lastIndexOf(46)) > 0) {
                line = line.substring(0, i);
            }
            if (line.contains("docker-")) {
                i = line.lastIndexOf("docker-");
                line = line.substring(i + 7);
            }
            return line.length() <= 65 ? line : line.substring(0, 65);
        }
        return null;
    }
}

