/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Comparator;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.di.Keys;

public class OrderedComparator
implements Comparator<AnnotatedElement> {
    public static final OrderedComparator INSTANCE = new OrderedComparator();

    @Override
    public int compare(AnnotatedElement lhs, AnnotatedElement rhs) {
        if (lhs == rhs) {
            return 0;
        }
        Ordered lhsOrder = lhs.getAnnotation(Ordered.class);
        Ordered rhsOrder = rhs.getAnnotation(Ordered.class);
        if (lhsOrder != null && rhsOrder != null) {
            return Integer.compare(lhsOrder.value(), rhsOrder.value());
        }
        if (lhsOrder != null) {
            return -1;
        }
        if (rhsOrder != null) {
            return 1;
        }
        return OrderedComparator.getName(lhs).compareToIgnoreCase(OrderedComparator.getName(rhs));
    }

    private static String getName(AnnotatedElement element) {
        if (element instanceof Class) {
            return Keys.getName((Class)element);
        }
        if (element instanceof Field) {
            return Keys.getName((Field)element);
        }
        if (element instanceof Parameter) {
            return Keys.getName((Parameter)element);
        }
        if (element instanceof Method) {
            return Keys.getName((Method)element);
        }
        if (element instanceof AnnotatedType) {
            return Keys.getName((AnnotatedType)element);
        }
        return "";
    }
}

