/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.agent.embedded.EmbeddedAgent;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.flume.appender.AbstractFlumeManager;
import org.apache.logging.log4j.flume.appender.Agent;
import org.apache.logging.log4j.util.NameUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class FlumeEmbeddedManager
extends AbstractFlumeManager {
    private static final String FILE_SEP = PropertiesUtil.getProperties().getStringProperty("file.separator");
    private static final String IN_MEMORY = "InMemory";
    private static final FlumeManagerFactory factory = new FlumeManagerFactory();
    private final EmbeddedAgent agent;
    private final String shortName;

    protected FlumeEmbeddedManager(String name, String shortName, EmbeddedAgent agent) {
        super(name);
        this.agent = agent;
        this.shortName = shortName;
    }

    public static FlumeEmbeddedManager getManager(String name, Agent[] agents, Property[] properties, int batchSize, String dataDir) {
        if (batchSize <= 0) {
            batchSize = 1;
        }
        if (!(agents != null && agents.length != 0 || properties != null && properties.length != 0)) {
            throw new IllegalArgumentException("Either an Agent or properties are required");
        }
        if (agents != null && agents.length > 0 && properties != null && properties.length > 0) {
            throw new IllegalArgumentException("Cannot configure both Agents and Properties.");
        }
        String managerName = FlumeEmbeddedManager.createManagerName(name, agents, properties);
        return (FlumeEmbeddedManager)FlumeEmbeddedManager.getManager((String)managerName, (ManagerFactory)factory, (Object)new FactoryData(name, agents, properties, batchSize, dataDir));
    }

    private static String createManagerName(String name, Agent[] agents, Property[] properties) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (agents != null && agents.length > 0) {
            sb.append(name).append('[');
            for (Agent agent : agents) {
                if (!first) {
                    sb.append('_');
                }
                sb.append(agent.getHost()).append('-').append(agent.getPort());
                first = false;
            }
            sb.append(']');
        } else {
            String sep = "";
            sb.append(name).append('-');
            StringBuilder props = new StringBuilder();
            for (Property prop : properties) {
                props.append(sep);
                props.append(prop.getName()).append('=').append(prop.getValue());
                sep = "_";
            }
            sb.append(NameUtil.md5((String)props.toString()));
        }
        return sb.toString();
    }

    @Override
    public void send(Event event) {
        try {
            this.agent.put(event);
        }
        catch (EventDeliveryException ex) {
            throw new LoggingException("Unable to deliver event to Flume Appender " + this.shortName, (Throwable)ex);
        }
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        this.agent.stop();
        return true;
    }

    private static class FlumeManagerFactory
    implements ManagerFactory<FlumeEmbeddedManager, FactoryData> {
        private FlumeManagerFactory() {
        }

        public FlumeEmbeddedManager createManager(String name, FactoryData data) {
            try {
                Map<String, String> props = this.createProperties(data.name, data.agents, data.properties, data.batchSize, data.dataDir);
                EmbeddedAgent agent = new EmbeddedAgent(name);
                agent.configure(props);
                agent.start();
                LOGGER.debug("Created Agent " + name);
                return new FlumeEmbeddedManager(name, data.name, agent);
            }
            catch (Exception ex) {
                LOGGER.error("Could not create FlumeEmbeddedManager", (Throwable)ex);
                return null;
            }
        }

        private Map<String, String> createProperties(String name, Agent[] agents, Property[] properties, int batchSize, String dataDir) {
            HashMap<String, String> props = new HashMap<String, String>();
            if (!(agents != null && agents.length != 0 || properties != null && properties.length != 0)) {
                LOGGER.error("No Flume configuration provided");
                throw new ConfigurationException("No Flume configuration provided");
            }
            if (agents != null && agents.length > 0 && properties != null && properties.length > 0) {
                LOGGER.error("Agents and Flume configuration cannot both be specified");
                throw new ConfigurationException("Agents and Flume configuration cannot both be specified");
            }
            if (agents != null && agents.length > 0) {
                if (Strings.isNotEmpty((CharSequence)dataDir)) {
                    if (((String)dataDir).equals(FlumeEmbeddedManager.IN_MEMORY)) {
                        props.put("channel.type", "memory");
                    } else {
                        props.put("channel.type", "file");
                        if (!((String)dataDir).endsWith(FILE_SEP)) {
                            dataDir = (String)dataDir + FILE_SEP;
                        }
                        props.put("channel.checkpointDir", (String)dataDir + "checkpoint");
                        props.put("channel.dataDirs", (String)dataDir + "data");
                    }
                } else {
                    props.put("channel.type", "file");
                }
                StringBuilder sb = new StringBuilder();
                String leading = "";
                int priority = agents.length;
                for (int i = 0; i < priority; ++i) {
                    sb.append(leading).append("agent").append(i);
                    leading = " ";
                    String prefix = "agent" + i;
                    props.put(prefix + ".type", "avro");
                    props.put(prefix + ".hostname", agents[i].getHost());
                    props.put(prefix + ".port", Integer.toString(agents[i].getPort()));
                    props.put(prefix + ".batch-size", Integer.toString(batchSize));
                    props.put("processor.priority." + prefix, Integer.toString(agents.length - i));
                }
                props.put("sinks", sb.toString());
                props.put("processor.type", "failover");
            } else {
                String[] sinks = null;
                for (Property property : properties) {
                    String key = property.getName();
                    if (Strings.isEmpty((CharSequence)key)) {
                        String msg = "A property name must be provided";
                        LOGGER.error("A property name must be provided");
                        throw new ConfigurationException("A property name must be provided");
                    }
                    String upperKey = key.toUpperCase(Locale.ENGLISH);
                    if (upperKey.startsWith(name.toUpperCase(Locale.ENGLISH))) {
                        String msg = "Specification of the agent name is not allowed in Flume Appender configuration: " + key;
                        LOGGER.error(msg);
                        throw new ConfigurationException(msg);
                    }
                    String value = property.getValue();
                    if (Strings.isEmpty((CharSequence)value)) {
                        String msg = "A value for property " + key + " must be provided";
                        LOGGER.error(msg);
                        throw new ConfigurationException(msg);
                    }
                    if (upperKey.equals("SINKS")) {
                        sinks = value.trim().split(" ");
                    }
                    props.put(key, value);
                }
                if (sinks == null || sinks.length == 0) {
                    String msg = "At least one Sink must be specified";
                    LOGGER.error("At least one Sink must be specified");
                    throw new ConfigurationException("At least one Sink must be specified");
                }
            }
            return props;
        }
    }

    private static class FactoryData {
        private final Agent[] agents;
        private final Property[] properties;
        private final int batchSize;
        private final String dataDir;
        private final String name;

        public FactoryData(String name, Agent[] agents, Property[] properties, int batchSize, String dataDir) {
            this.name = name;
            this.agents = agents;
            this.batchSize = batchSize;
            this.properties = properties;
            this.dataDir = dataDir;
        }
    }
}

