/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson.json.layout;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.jackson.AbstractJacksonFactory;
import org.apache.logging.log4j.jackson.json.Log4jJsonObjectMapper;

class JsonJacksonFactory
extends AbstractJacksonFactory {
    private final boolean encodeThreadContextAsList;
    private final boolean objectMessageAsJsonObject;

    public JsonJacksonFactory(boolean encodeThreadContextAsList, boolean includeStacktrace, boolean stacktraceAsString, boolean objectMessageAsJsonObject) {
        super(includeStacktrace, stacktraceAsString);
        this.encodeThreadContextAsList = encodeThreadContextAsList;
        this.objectMessageAsJsonObject = objectMessageAsJsonObject;
    }

    protected String getPropertyNameForContextMap() {
        return "contextMap";
    }

    protected String getPropertyNameForTimeMillis() {
        return "timeMillis";
    }

    protected String getPropertyNameForInstant() {
        return "instant";
    }

    protected String getPropertyNameForNanoTime() {
        return "nanoTime";
    }

    protected String getPropertyNameForSource() {
        return "source";
    }

    protected String getPropertyNameForStackTrace() {
        return "extendedStackTrace";
    }

    protected PrettyPrinter newCompactPrinter() {
        return new MinimalPrettyPrinter();
    }

    protected ObjectMapper newObjectMapper() {
        return new Log4jJsonObjectMapper(this.encodeThreadContextAsList, this.includeStacktrace, this.stacktraceAsString, this.objectMessageAsJsonObject);
    }

    protected PrettyPrinter newPrettyPrinter() {
        return new DefaultPrettyPrinter();
    }
}

