/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.parser;

import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;

public abstract class AbstractLogEventParserTest {
    protected void assertLogEvent(LogEvent logEvent) {
        MatcherAssert.assertThat((Object)logEvent, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)logEvent.getInstant().getEpochMillisecond(), (Matcher)CoreMatchers.equalTo((Object)1493121664118L));
        MatcherAssert.assertThat((Object)logEvent.getThreadName(), (Matcher)CoreMatchers.equalTo((Object)"main"));
        MatcherAssert.assertThat((Object)logEvent.getThreadId(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)logEvent.getThreadPriority(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)logEvent.getLevel(), (Matcher)CoreMatchers.equalTo((Object)Level.INFO));
        MatcherAssert.assertThat((Object)logEvent.getLoggerName(), (Matcher)CoreMatchers.equalTo((Object)"HelloWorld"));
        MatcherAssert.assertThat((Object)logEvent.getMarker().getName(), (Matcher)CoreMatchers.equalTo((Object)"child"));
        MatcherAssert.assertThat((Object)logEvent.getMarker().getParents()[0].getName(), (Matcher)CoreMatchers.equalTo((Object)"parent"));
        MatcherAssert.assertThat((Object)logEvent.getMarker().getParents()[0].getParents()[0].getName(), (Matcher)CoreMatchers.equalTo((Object)"grandparent"));
        MatcherAssert.assertThat((Object)logEvent.getMessage().getFormattedMessage(), (Matcher)CoreMatchers.equalTo((Object)"Hello, world!"));
        MatcherAssert.assertThat((Object)logEvent.getThrown(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)logEvent.getThrownProxy().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"error message"));
        MatcherAssert.assertThat((Object)logEvent.getThrownProxy().getName(), (Matcher)CoreMatchers.equalTo((Object)"java.lang.RuntimeException"));
        MatcherAssert.assertThat((Object)logEvent.getThrownProxy().getExtendedStackTrace()[0].getClassName(), (Matcher)CoreMatchers.equalTo((Object)"logtest.Main"));
        MatcherAssert.assertThat((Object)logEvent.getLoggerFqcn(), (Matcher)CoreMatchers.equalTo((Object)"org.apache.logging.log4j.spi.AbstractLogger"));
        MatcherAssert.assertThat((Object)logEvent.getContextStack().asList(), (Matcher)CoreMatchers.equalTo(Arrays.asList("one", "two")));
        MatcherAssert.assertThat((Object)((String)logEvent.getContextData().getValue("foo")), (Matcher)CoreMatchers.equalTo((Object)"FOO"));
        MatcherAssert.assertThat((Object)((String)logEvent.getContextData().getValue("bar")), (Matcher)CoreMatchers.equalTo((Object)"BAR"));
        MatcherAssert.assertThat((Object)logEvent.getSource().getClassName(), (Matcher)CoreMatchers.equalTo((Object)"logtest.Main"));
    }
}

