/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.test.junit.ContextSelectorType;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.di.Injector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class ContextSelectorCallback
implements BeforeAllCallback,
AfterAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestClass(), ContextSelectorType.class).map(ContextSelectorType::value).ifPresent(contextSelectorClass -> {
            Injector injector = DI.createInjector();
            injector.registerBinding(ContextSelector.KEY, injector.getFactory(contextSelectorClass));
            injector.init();
            Log4jContextFactory factory = (Log4jContextFactory)injector.getInstance(Log4jContextFactory.class);
            LogManager.setFactory((LoggerContextFactory)factory);
        });
    }

    public void afterAll(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestClass(), ContextSelectorType.class).ifPresent(ignored -> LogManager.setFactory(null));
    }
}

