/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jms.appender;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.jms.appender.JmsManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="JMS")
@PluginAliases(value={"JMSQueue", "JMSTopic"})
public class JmsAppender
extends AbstractAppender {
    private final JmsManager manager;

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    protected JmsAppender(String name, Filter filter, Layout layout, boolean ignoreExceptions, Property[] properties, JmsManager manager) throws JMSException {
        super(name, filter, layout, ignoreExceptions, properties);
        this.manager = manager;
    }

    public void append(LogEvent event) {
        this.manager.send(event, this.getLayout());
    }

    public JmsManager getManager() {
        return this.manager;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped &= this.manager.stop(timeout, timeUnit);
    }

    public static final class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<JmsAppender> {
        public static final int DEFAULT_RECONNECT_INTERVAL_MILLIS = 5000;
        @PluginBuilderAttribute
        private String factoryName;
        @PluginBuilderAttribute
        private String providerUrl;
        @PluginBuilderAttribute
        private String urlPkgPrefixes;
        @PluginBuilderAttribute
        private String securityPrincipalName;
        @PluginBuilderAttribute(sensitive=true)
        private String securityCredentials;
        @PluginBuilderAttribute
        @Required(message="A javax.jms.ConnectionFactory JNDI name must be specified")
        private String factoryBindingName;
        @PluginBuilderAttribute
        @PluginAliases(value={"queueBindingName", "topicBindingName"})
        @Required(message="A javax.jms.Destination JNDI name must be specified")
        private String destinationBindingName;
        @PluginBuilderAttribute
        private String userName;
        @PluginBuilderAttribute(sensitive=true)
        private char[] password;
        @PluginBuilderAttribute
        private long reconnectIntervalMillis = 5000L;
        @PluginBuilderAttribute
        private boolean immediateFail;
        private JmsManager jmsManager;

        private Builder() {
        }

        public JmsAppender build() {
            if (!Constants.JNDI_JMS_ENABLED) {
                LOGGER.error("JNDI has not been enabled. The log4j2.enableJndi property must be set to true");
                return null;
            }
            JmsManager actualJmsManager = this.jmsManager;
            JmsManager.JmsManagerConfiguration configuration = null;
            if (actualJmsManager == null) {
                Properties additionalProperties = null;
                Properties jndiProperties = JmsManager.createJndiProperties(this.factoryName, this.providerUrl, this.urlPkgPrefixes, this.securityPrincipalName, this.securityCredentials, additionalProperties);
                configuration = new JmsManager.JmsManagerConfiguration(jndiProperties, this.factoryBindingName, this.destinationBindingName, this.userName, this.password, false, this.reconnectIntervalMillis);
                actualJmsManager = (JmsManager)AbstractManager.getManager((String)this.getName(), (ManagerFactory)JmsManager.FACTORY, (Object)configuration);
            }
            if (actualJmsManager == null) {
                return null;
            }
            try {
                return new JmsAppender(this.getName(), this.getFilter(), this.getLayout(), this.isIgnoreExceptions(), this.getPropertyArray(), actualJmsManager);
            }
            catch (JMSException e) {
                throw new IllegalStateException(e);
            }
        }

        public B setDestinationBindingName(String destinationBindingName) {
            this.destinationBindingName = destinationBindingName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFactoryBindingName(String factoryBindingName) {
            this.factoryBindingName = factoryBindingName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFactoryName(String factoryName) {
            this.factoryName = factoryName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setImmediateFail(boolean immediateFail) {
            this.immediateFail = immediateFail;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setJmsManager(JmsManager jmsManager) {
            this.jmsManager = jmsManager;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPassword(char[] password) {
            this.password = password;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProviderUrl(String providerUrl) {
            this.providerUrl = providerUrl;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setReconnectIntervalMillis(long reconnectIntervalMillis) {
            this.reconnectIntervalMillis = reconnectIntervalMillis;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setSecurityCredentials(String securityCredentials) {
            this.securityCredentials = securityCredentials;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setSecurityPrincipalName(String securityPrincipalName) {
            this.securityPrincipalName = securityPrincipalName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUrlPkgPrefixes(String urlPkgPrefixes) {
            this.urlPkgPrefixes = urlPkgPrefixes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUserName(String userName) {
            this.userName = userName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String toString() {
            return "Builder [name=" + this.getName() + ", factoryName=" + this.factoryName + ", providerUrl=" + this.providerUrl + ", urlPkgPrefixes=" + this.urlPkgPrefixes + ", securityPrincipalName=" + this.securityPrincipalName + ", securityCredentials=" + this.securityCredentials + ", factoryBindingName=" + this.factoryBindingName + ", destinationBindingName=" + this.destinationBindingName + ", username=" + this.userName + ", layout=" + this.getLayout() + ", filter=" + this.getFilter() + ", ignoreExceptions=" + this.isIgnoreExceptions() + ", jmsManager=" + this.jmsManager + "]";
        }
    }
}

