/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jpa.appender;

import java.lang.reflect.Constructor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.jpa.appender.AbstractLogEventWrapperEntity;
import org.apache.logging.log4j.jpa.appender.JpaDatabaseManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="JPA")
public final class JpaAppender
extends AbstractDatabaseAppender<JpaDatabaseManager> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    private JpaAppender(String name, Filter filter, boolean ignoreExceptions, Property[] properties, JpaDatabaseManager manager) {
        super(name, filter, null, ignoreExceptions, properties, (AbstractDatabaseManager)manager);
    }

    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static JpaAppender createAppender(@PluginAttribute String name, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement Filter filter, @PluginAttribute String bufferSize, @PluginAttribute String entityClassName, @PluginAttribute String persistenceUnitName) {
        if (Strings.isEmpty((CharSequence)entityClassName) || Strings.isEmpty((CharSequence)persistenceUnitName)) {
            LOGGER.error("Attributes entityClassName and persistenceUnitName are required for JPA Appender.");
            return null;
        }
        int bufferSizeInt = AbstractAppender.parseInt((String)bufferSize, (int)0);
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        try {
            Class<AbstractLogEventWrapperEntity> entityClass = LoaderUtil.loadClass((String)entityClassName).asSubclass(AbstractLogEventWrapperEntity.class);
            try {
                entityClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Entity class [{}] does not have a no-arg constructor. The JPA provider will reject it.", (Object)entityClassName);
                return null;
            }
            Constructor<AbstractLogEventWrapperEntity> entityConstructor = entityClass.getConstructor(LogEvent.class);
            String managerName = "jpaManager{ description=" + name + ", bufferSize=" + bufferSizeInt + ", persistenceUnitName=" + persistenceUnitName + ", entityClass=" + entityClass.getName() + "}";
            JpaDatabaseManager manager = JpaDatabaseManager.getJPADatabaseManager(managerName, bufferSizeInt, entityClass, entityConstructor, persistenceUnitName);
            if (manager == null) {
                return null;
            }
            return new JpaAppender(name, filter, ignoreExceptions, null, manager);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not load entity class [{}].", (Object)entityClassName, (Object)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Entity class [{}] does not have a constructor with a single argument of type LogEvent.", (Object)entityClassName);
            return null;
        }
        catch (ClassCastException e) {
            LOGGER.error("Entity class [{}] does not extend AbstractLogEventWrapperEntity.", (Object)entityClassName);
            return null;
        }
    }
}

