/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import org.apache.flume.ChannelException;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4jEventSource
extends AbstractSource
implements EventDrivenSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(Log4jEventSource.class);
    private final SourceCounter sourceCounter = new SourceCounter("log4j");

    public Log4jEventSource() {
        this.setName("Log4jEvent");
    }

    public synchronized void start() {
        super.start();
        LOGGER.info("Log4j Source started");
    }

    public synchronized void stop() {
        super.stop();
        LOGGER.info("Log4j Source stopped. Metrics {}", (Object)this.sourceCounter);
    }

    public void send(Event event) {
        this.sourceCounter.incrementAppendReceivedCount();
        this.sourceCounter.incrementEventReceivedCount();
        try {
            this.getChannelProcessor().processEvent(event);
        }
        catch (ChannelException ex) {
            LOGGER.warn("Unable to process event {}", (Object)event, (Object)ex);
            throw ex;
        }
        this.sourceCounter.incrementAppendAcceptedCount();
        this.sourceCounter.incrementEventAcceptedCount();
    }
}

