/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.net.mock;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.apache.logging.log4j.core.test.net.mock.MockSyslogServer;
import org.apache.logging.log4j.core.util.Throwables;

public class MockUdpSyslogServer
extends MockSyslogServer {
    private final DatagramSocket socket;
    private volatile boolean shutdown = false;
    private Thread thread;

    public MockUdpSyslogServer(int numberOfMessagesToReceive, int port) throws SocketException {
        super(numberOfMessagesToReceive, port);
        this.socket = new DatagramSocket(port);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException ie) {
                System.out.println("Shutdown of Log4j UDP server thread failed.");
            }
        }
    }

    @Override
    public void run() {
        block3: {
            System.out.println("Log4j UDP Server started.");
            this.thread = Thread.currentThread();
            byte[] bytes = new byte[4096];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            try {
                while (!this.shutdown) {
                    this.socket.receive(packet);
                    String str = new String(packet.getData(), 0, packet.getLength());
                    this.messageList.add(str);
                }
            }
            catch (Exception e) {
                if (this.shutdown) break block3;
                Throwables.rethrow((Throwable)e);
            }
        }
        System.out.println("Log4j UDP server stopped.");
    }
}

