/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public final class JsonObjectMapperFactory {
    private static final String LOCAL_DATE_TIME_FORMAT = "yyyyMMddHHmmss.SSS";
    private static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS");
    private static final String LOCAL_DATE_FORMAT = "yyyyMMdd";
    private static final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String ZONED_DATE_TIME_FORMAT = "yyyyMMddHHmmss.SSSZ";
    public static final DateTimeFormatter ZONED_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSSZ");

    private JsonObjectMapperFactory() {
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().build();
        DateTimeFormatter dateTimeFormatter = LOCAL_DATE_TIME_FORMATTER;
        DateTimeFormatter dateFormatter = LOCAL_DATE_FORMATTER;
        DateTimeFormatter zonedTimeFormatter = ZONED_DATE_TIME_FORMATTER;
        SimpleModule module = new SimpleModule();
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new /* Unavailable Anonymous Inner Class!! */);
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new /* Unavailable Anonymous Inner Class!! */);
        module.addSerializer(LocalDate.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */);
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new /* Unavailable Anonymous Inner Class!! */);
        mapper.registerModule((Module)module);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }
}

