/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class InMemoryQueryIndirectionPolicy
implements Serializable {
    public static final int SHOULD_THROW_INDIRECTION_EXCEPTION = 0;
    public static final int SHOULD_TRIGGER_INDIRECTION = 1;
    public static final int SHOULD_IGNORE_EXCEPTION_RETURN_CONFORMED = 2;
    public static final int SHOULD_IGNORE_EXCEPTION_RETURN_NOT_CONFORMED = 3;
    protected int policy;
    protected ObjectLevelReadQuery query;

    public InMemoryQueryIndirectionPolicy() {
        this.policy = 0;
    }

    public InMemoryQueryIndirectionPolicy(int policyValue) {
        this.policy = policyValue;
    }

    public InMemoryQueryIndirectionPolicy(int policy, ObjectLevelReadQuery query) {
        this.policy = policy;
        this.query = query;
    }

    public boolean shouldTriggerIndirection() {
        return this.policy == 1;
    }

    public boolean shouldThrowIndirectionException() {
        return this.policy == 0;
    }

    public boolean shouldIgnoreIndirectionExceptionReturnConformed() {
        return this.policy == 2;
    }

    public boolean shouldIgnoreIndirectionExceptionReturnNotConformed() {
        return this.policy == 3;
    }

    public void ignoreIndirectionExceptionReturnNotConformed() {
        this.setPolicy(3);
    }

    public void ignoreIndirectionExceptionReturnConformed() {
        this.setPolicy(2);
    }

    public void triggerIndirection() {
        this.setPolicy(1);
    }

    public void throwIndirectionException() {
        this.setPolicy(0);
    }

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int policy) {
        this.policy = policy;
        if (this.query != null) {
            this.query.setInMemoryQueryIndirectionPolicyState(policy);
        }
    }

    public ObjectLevelReadQuery getQuery() {
        return this.query;
    }

    public void setQuery(ObjectLevelReadQuery query) {
        this.query = query;
    }
}

