/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svgToString;

import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgImageElementEx;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import jetbrains.datalore.vis.svg.SvgTextNode;
import jetbrains.datalore.vis.svgToString.PrebuiltSvgSubtree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/vis/svgToString/SvgToString;", "", "rgbEncoder", "Ljetbrains/datalore/vis/svg/SvgImageElementEx$RGBEncoder;", "(Ljetbrains/datalore/vis/svg/SvgImageElementEx$RGBEncoder;)V", "render", "", "svg", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "renderElement", "", "svgElement", "Ljetbrains/datalore/vis/svg/SvgElement;", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "", "renderTextNode", "node", "Ljetbrains/datalore/vis/svg/SvgTextNode;", "Companion", "vis-svg-portable"})
public final class SvgToString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SvgImageElementEx.RGBEncoder rgbEncoder;
    private static final int TAB = 2;

    public SvgToString(@Nullable SvgImageElementEx.RGBEncoder rgbEncoder) {
        this.rgbEncoder = rgbEncoder;
    }

    @NotNull
    public final String render(@NotNull SvgSvgElement svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        StringBuilder buffer = new StringBuilder();
        this.renderElement(svg, buffer, 0);
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final void renderElement(SvgElement svgElement, StringBuilder buffer, int level) {
        if (level > 0) {
            Companion.crlf(buffer, level);
        }
        buffer.append('<').append(svgElement.getElementName());
        if (svgElement.getElementName().equals("svg")) {
            buffer.append(" xmlns").append("=\"").append("http://www.w3.org/2000/svg").append('\"');
            buffer.append(" xmlns:").append("xlink").append("=\"").append("http://www.w3.org/1999/xlink").append('\"');
        }
        for (SvgAttributeSpec<?> key : svgElement.getAttributeKeys()) {
            buffer.append(' ');
            String name = key.getName();
            String value = String.valueOf(svgElement.getAttribute(name).get());
            buffer.append(name).append("=\"").append(value).append('\"');
        }
        buffer.append('>');
        if (svgElement.isPrebuiltSubtree()) {
            for (SvgNode childNode : svgElement.children()) {
                Companion.crlf(buffer, level + 1);
                PrebuiltSvgSubtree subtree = new PrebuiltSvgSubtree(childNode, level + 1);
                buffer.append(subtree.getAsString());
            }
        } else {
            for (SvgNode childNode : svgElement.children()) {
                SvgNode childNode2 = childNode;
                if (childNode2 instanceof SvgTextNode) {
                    this.renderTextNode((SvgTextNode)childNode2, buffer, level);
                    continue;
                }
                if (childNode2 instanceof SvgElement) {
                    if (childNode2 instanceof SvgImageElementEx) {
                        if (this.rgbEncoder == null) continue;
                        childNode2 = ((SvgImageElementEx)childNode2).asImageElement(this.rgbEncoder);
                    }
                    SvgNode svgNode = childNode2;
                    Intrinsics.checkNotNull((Object)((Object)svgNode), (String)"null cannot be cast to non-null type jetbrains.datalore.vis.svg.SvgElement");
                    this.renderElement((SvgElement)svgNode, buffer, level + 1);
                    continue;
                }
                throw new IllegalStateException("Can't render unsupported svg node: " + (Object)((Object)childNode2));
            }
        }
        Companion.crlf(buffer, level);
        buffer.append("</").append(svgElement.getElementName()).append('>');
    }

    private final void renderTextNode(SvgTextNode node, StringBuilder buffer, int level) {
        Companion.crlf(buffer, level);
        buffer.append(Companion.htmlEscape((String)node.textContent().get()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/vis/svgToString/SvgToString$Companion;", "", "()V", "TAB", "", "crlf", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "htmlEscape", "", "str", "vis-svg-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String htmlEscape(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            StringBuilder escaped = new StringBuilder();
            CharSequence $this$forEach$iv = str;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char ch = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                char c = ch;
                escaped.append(c == '&' ? "&amp;" : (c == '<' ? "&lt;" : (c == '>' ? "&gt;" : (c == '\"' ? "&quot;" : (c == '\'' ? "&#39;" : Character.valueOf(ch))))));
            }
            String string = escaped.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escaped.toString()");
            return string;
        }

        public final void crlf(@NotNull StringBuilder buffer, int level) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.append('\n');
            int n = level * 2;
            for (int i = 0; i < n; ++i) {
                buffer.append(' ');
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

