/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@AutoService(value={Command.class})
public class Remove
extends AbstractAction {
    private static final Set<String> commands = new HashSet<String>();
    private static final boolean SKIP_CONFIRM = JMeterUtils.getPropDefault("confirm.delete.skip", false);

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        int isConfirm;
        int n = isConfirm = SKIP_CONFIRM ? 0 : JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("remove_confirm_msg"), JMeterUtils.getResString("remove_confirm_title"), 0, 3);
        if (isConfirm == 0) {
            ActionRouter.getInstance().actionPerformed(new ActionEvent(e.getSource(), e.getID(), "check_remove"));
            GuiPackage guiPackage = GuiPackage.getInstance();
            JMeterTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
            TreePath newTreePath = guiPackage.getTreeListener().removedSelectedNode();
            for (int i = nodes.length - 1; i >= 0; --i) {
                Remove.removeNode(nodes[i]);
            }
            guiPackage.getTreeListener().getJTree().setSelectionPath(newTreePath);
            guiPackage.updateCurrentGui();
        }
    }

    private static void removeNode(JMeterTreeNode node) {
        TestElement testElement = node.getTestElement();
        if (testElement.canRemove()) {
            GuiPackage.getInstance().getTreeModel().removeNodeFromParent(node);
            GuiPackage.getInstance().removeNode(testElement);
            testElement.removed();
        } else {
            String message = testElement.getClass().getName() + " is busy";
            JOptionPane.showMessageDialog(null, message, "Cannot remove item", 0);
        }
    }

    static {
        commands.add("remove");
    }
}

