/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.canvas.awt;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.vis.canvas.Canvas;
import jetbrains.datalore.vis.canvas.Context2d;
import jetbrains.datalore.vis.canvas.Font;
import jetbrains.datalore.vis.canvas.FontStyle;
import jetbrains.datalore.vis.canvas.FontWeight;
import jetbrains.datalore.vis.canvas.LineCap;
import jetbrains.datalore.vis.canvas.LineJoin;
import jetbrains.datalore.vis.canvas.TextAlign;
import jetbrains.datalore.vis.canvas.TextBaseline;
import jetbrains.datalore.vis.canvas.awt.AwtCanvas;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001{B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J8\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0016J \u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J0\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0016JP\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0016J\b\u00102\u001a\u00020\rH\u0016J\b\u00103\u001a\u00020\rH\u0016J(\u00104\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000fH\u0016J \u00107\u001a\u00020\r2\u0006\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010:\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u000209H\u0016J\u0018\u0010=\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J4\u0010>\u001a\u00020\r2\u0006\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\r0@H\u0002J\b\u0010B\u001a\u00020\rH\u0016J\u0010\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\u000fH\u0016J\b\u0010E\u001a\u00020\rH\u0016J\u0010\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\u000fH\u0016J\u0018\u0010F\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010H\u001a\u00020\r2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0010\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u000fH\u0016J\u0010\u0010P\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010Q\u001a\u00020\r2\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010U\u001a\u00020\r2\u0006\u0010V\u001a\u00020\u000fH\u0016J\u0012\u0010W\u001a\u00020\r2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0010\u0010X\u001a\u00020\r2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\r2\u0006\u0010\\\u001a\u00020]H\u0016J8\u0010^\u001a\u00020\r2\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020\u000f2\u0006\u0010a\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0016J\b\u0010c\u001a\u00020\rH\u0016J(\u0010d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000fH\u0016J \u0010e\u001a\u00020\r2\u0006\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J \u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J8\u0010j\u001a\u00020\r2\u0006\u0010_\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020\u000f2\u0006\u0010a\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0016J\u0018\u0010k\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016JJ\u0010l\u001a\u00020m*\u00020m2\b\b\u0002\u0010n\u001a\u00020o2\b\b\u0002\u0010p\u001a\u00020!2\b\b\u0002\u0010q\u001a\u00020!2\b\b\u0002\u0010r\u001a\u00020o2\n\b\u0002\u0010s\u001a\u0004\u0018\u00010t2\b\b\u0002\u0010u\u001a\u00020oH\u0002J\u0014\u0010h\u001a\u00020i*\u00020\u00032\u0006\u0010<\u001a\u000209H\u0002J\f\u0010v\u001a\u00020w*\u00020JH\u0002J\u0010\u0010x\u001a\u00060yj\u0002`z*\u00020MH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Ljetbrains/datalore/vis/canvas/awt/AwtContext2d;", "Ljetbrains/datalore/vis/canvas/Context2d;", "graphics", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;)V", "currentPath", "Ljava/awt/geom/GeneralPath;", "stack", "Ljava/util/ArrayList;", "Ljetbrains/datalore/vis/canvas/awt/AwtContext2d$ContextState;", "Lkotlin/collections/ArrayList;", "state", "arc", "", "x", "", "y", "radius", "startAngle", "endAngle", "anticlockwise", "", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "clearRect", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "closePath", "convertLineCap", "", "lineCap", "Ljetbrains/datalore/vis/canvas/LineCap;", "convertLineJoin", "lineJoin", "Ljetbrains/datalore/vis/canvas/LineJoin;", "drawImage", "snapshot", "Ljetbrains/datalore/vis/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "fill", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "", "lineTo", "measureText", "str", "moveTo", "paintText", "painter", "Lkotlin/Function1;", "Ljava/awt/Shape;", "restore", "rotate", "angle", "save", "scale", "xy", "setFillStyle", "color", "Ljetbrains/datalore/base/values/Color;", "setFont", "f", "Ljetbrains/datalore/vis/canvas/Font;", "setGlobalAlpha", "alpha", "setLineCap", "setLineDash", "lineDash", "", "setLineJoin", "setLineWidth", "lineWidth", "setStrokeStyle", "setTextAlign", "align", "Ljetbrains/datalore/vis/canvas/TextAlign;", "setTextBaseline", "baseline", "Ljetbrains/datalore/vis/canvas/TextBaseline;", "setTransform", "m11", "m12", "m21", "m22", "stroke", "strokeRect", "strokeText", "textPosition", "Ljetbrains/datalore/base/geometry/DoubleVector;", "glyphVector", "Ljava/awt/font/GlyphVector;", "transform", "translate", "change", "Ljava/awt/BasicStroke;", "width", "", "join", "cap", "miterlimit", "dash", "", "dashPhase", "toAwtColor", "Ljava/awt/Color;", "toAwtFont", "Ljava/awt/Font;", "Ljetbrains/datalore/vis/canvas/awt/AwtFont;", "ContextState", "vis-canvas"})
public final class AwtContext2d
implements Context2d {
    @NotNull
    private final Graphics2D graphics;
    @Nullable
    private GeneralPath currentPath;
    @NotNull
    private ContextState state;
    @NotNull
    private final ArrayList<ContextState> stack;

    public AwtContext2d(@NotNull Graphics2D graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        this.graphics = graphics;
        this.state = new ContextState(null, null, null, null, null, null, 0.0f, null, 255, null);
        this.stack = new ArrayList();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D = this.graphics;
        Map p0 = renderingHints;
        boolean bl = false;
        graphics2D.setRenderingHints(p0);
        this.graphics.setBackground(this.toAwtColor(jetbrains.datalore.base.values.Color.Companion.getTRANSPARENT()));
        this.setLineCap(LineCap.BUTT);
    }

    private final int convertLineJoin(LineJoin lineJoin) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[lineJoin.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int convertLineCap(LineCap lineCap) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[lineCap.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final BasicStroke change(BasicStroke $this$change, float width2, int join, int cap, float miterlimit, float[] dash, float dashPhase) {
        return new BasicStroke(width2, cap, join, miterlimit, dash, dashPhase);
    }

    static /* synthetic */ BasicStroke change$default(AwtContext2d awtContext2d, BasicStroke basicStroke, float f, int n, int n2, float f2, float[] fArray, float f3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            f = basicStroke.getLineWidth();
        }
        if ((n3 & 2) != 0) {
            n = basicStroke.getLineJoin();
        }
        if ((n3 & 4) != 0) {
            n2 = basicStroke.getEndCap();
        }
        if ((n3 & 8) != 0) {
            f2 = basicStroke.getMiterLimit();
        }
        if ((n3 & 0x10) != 0) {
            fArray = basicStroke.getDashArray();
        }
        if ((n3 & 0x20) != 0) {
            f3 = basicStroke.getDashPhase();
        }
        return awtContext2d.change(basicStroke, f, n, n2, f2, fArray, f3);
    }

    private final GlyphVector glyphVector(Graphics2D $this$glyphVector, String str) {
        GlyphVector glyphVector = $this$glyphVector.getFont().createGlyphVector($this$glyphVector.getFontRenderContext(), str);
        Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"font.createGlyphVector(\n\u2026            str\n        )");
        return glyphVector;
    }

    private final DoubleVector textPosition(GlyphVector glyphVector, double x2, double y2) {
        double d;
        double d2;
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"glyphVector.visualBounds");
        Rectangle2D box = rectangle2D;
        FontMetrics fm = this.graphics.getFontMetrics();
        switch (WhenMappings.$EnumSwitchMapping$2[this.state.getTextAlign().ordinal()]) {
            case 1: {
                d2 = x2;
                break;
            }
            case 2: {
                d2 = x2 - box.getWidth() / (double)2;
                break;
            }
            case 3: {
                d2 = x2 - box.getWidth();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offsetX = d2;
        switch (WhenMappings.$EnumSwitchMapping$3[this.state.getTextBaseline().ordinal()]) {
            case 1: {
                d = y2;
                break;
            }
            case 2: {
                d = y2 - (double)fm.getDescent();
                break;
            }
            case 3: {
                d = y2 + (double)((fm.getLeading() + fm.getAscent() - fm.getDescent()) / 2);
                break;
            }
            case 4: {
                d = y2 + (double)fm.getLeading() + (double)fm.getAscent();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offsetY = d;
        return new DoubleVector(offsetX, offsetY);
    }

    private final void paintText(String text, double x2, double y2, Function1<? super Shape, Unit> painter) {
        AffineTransform savedTransform = this.graphics.getTransform();
        GlyphVector gv = this.glyphVector(this.graphics, text);
        DoubleVector position = this.textPosition(gv, x2, y2);
        this.graphics.translate(position.getX(), position.getY());
        Shape shape = gv.getOutline();
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"gv.outline");
        painter.invoke((Object)shape);
        this.graphics.setTransform(savedTransform);
    }

    private final Color toAwtColor(jetbrains.datalore.base.values.Color $this$toAwtColor) {
        return new Color($this$toAwtColor.getRed(), $this$toAwtColor.getGreen(), $this$toAwtColor.getBlue(), $this$toAwtColor.getAlpha());
    }

    private final java.awt.Font toAwtFont(Font $this$toAwtFont) {
        int n;
        int n2;
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toAwtFont.getFontWeight().ordinal()]) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int weight = n2;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toAwtFont.getFontStyle().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int style = n;
        return new java.awt.Font($this$toAwtFont.getFontFamily(), weight | style, (int)$this$toAwtFont.getFontSize());
    }

    @Override
    public void clearRect(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this.graphics.clearRect((int)rect2.getLeft(), (int)rect2.getTop(), (int)rect2.getWidth(), (int)rect2.getHeight());
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.drawImage(snapshot, 0.0, 0.0);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage((Image)awtSnapshot.getImage(), (int)x2, (int)y2, null);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage(awtSnapshot.getImage(), (int)x2, (int)y2, (int)dw, (int)dh, null);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage(awtSnapshot.getImage(), (int)dx, (int)dy, (int)dw + (int)dx, (int)dh + (int)dy, (int)sx, (int)sy, (int)sw + (int)sx, (int)sh + (int)sy, null);
    }

    @Override
    public void beginPath() {
        this.currentPath = new GeneralPath();
    }

    @Override
    public void closePath() {
        Unit unit;
        GeneralPath generalPath = this.currentPath;
        if (generalPath != null) {
            generalPath.closePath();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Can't find path".toString());
        }
    }

    @Override
    public void stroke() {
        this.graphics.setColor(this.state.getStrokeColor());
        this.graphics.draw(this.currentPath);
    }

    @Override
    public void fill() {
        this.graphics.setColor(this.state.getFillColor());
        this.graphics.fill(this.currentPath);
    }

    @Override
    public void fillEvenOdd() {
        this.graphics.setColor(this.state.getFillColor());
        GeneralPath generalPath = this.currentPath;
        if (generalPath != null) {
            generalPath.setWindingRule(0);
        }
        this.graphics.fill(this.currentPath);
    }

    @Override
    public void fillRect(double x2, double y2, double w, double h) {
        this.graphics.setColor(this.state.getFillColor());
        this.graphics.fillRect((int)x2, (int)y2, (int)w, (int)h);
    }

    @Override
    public void moveTo(double x2, double y2) {
        block0: {
            GeneralPath generalPath = this.currentPath;
            if (generalPath == null) break block0;
            generalPath.moveTo(x2, y2);
        }
    }

    @Override
    public void lineTo(double x2, double y2) {
        block0: {
            GeneralPath generalPath = this.currentPath;
            if (generalPath == null) break block0;
            generalPath.lineTo(x2, y2);
        }
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        block6: {
            double start2 = MathKt.toDegrees(startAngle) % (double)360;
            double end = MathKt.toDegrees(endAngle) % (double)360;
            double length = 0.0;
            if (start2 == end && !(startAngle == endAngle)) {
                length = 360.0;
            } else {
                if (start2 > end && end < 0.0) {
                    end += (double)360;
                } else if (start2 > end && end >= 0.0) {
                    start2 -= (double)360;
                }
                length = end - start2;
            }
            if (anticlockwise && !(length == 0.0) && !(length == 360.0)) {
                length -= (double)360;
            }
            Arc2D.Double it = new Arc2D.Double(x2 - radius, y2 - radius, radius * (double)2, radius * (double)2, -start2, -length, 0);
            boolean bl = false;
            GeneralPath generalPath = this.currentPath;
            if (generalPath == null) break block6;
            generalPath.append(it, true);
        }
    }

    @Override
    public void save() {
        this.stack.add(ContextState.copy$default(this.state, null, null, null, null, null, null, 0.0f, null, 255, null));
    }

    @Override
    public void restore() {
        block0: {
            ContextState contextState = (ContextState)CollectionsKt.lastOrNull((List)this.stack);
            if (contextState == null) break block0;
            ContextState it = contextState;
            boolean bl = false;
            this.state = it;
            this.graphics.setTransform(this.state.getTransform());
            this.graphics.setStroke(this.state.getStroke());
            this.graphics.setFont(this.state.getFont());
            this.graphics.setComposite(AlphaComposite.getInstance(3, this.state.getGlobalAlpha()));
            this.stack.remove(CollectionsKt.getLastIndex((List)this.stack));
        }
    }

    @Override
    public void setFillStyle(@Nullable jetbrains.datalore.base.values.Color color) {
        Object object = color;
        if (object == null || (object = this.toAwtColor((jetbrains.datalore.base.values.Color)object)) == null) {
            Color color2 = Color.BLACK;
            object = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        this.state.setFillColor((Color)object);
    }

    @Override
    public void setStrokeStyle(@Nullable jetbrains.datalore.base.values.Color color) {
        Object object = color;
        if (object == null || (object = this.toAwtColor((jetbrains.datalore.base.values.Color)object)) == null) {
            Color color2 = Color.BLACK;
            object = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        this.state.setStrokeColor((Color)object);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.state.setGlobalAlpha((float)alpha);
        this.graphics.setComposite(AlphaComposite.getInstance(3, this.state.getGlobalAlpha()));
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.state.setFont(this.toAwtFont(f));
        this.graphics.setFont(this.state.getFont());
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.state.setStroke(AwtContext2d.change$default(this, this.state.getStroke(), (float)lineWidth, 0, 0, 0.0f, null, 0.0f, 62, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    @Override
    public void strokeRect(double x2, double y2, double w, double h) {
        this.graphics.setColor(this.state.getStrokeColor());
        this.graphics.drawRect((int)x2, (int)y2, (int)w, (int)h);
    }

    @Override
    public void strokeText(@NotNull String text, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.graphics.setColor(this.state.getStrokeColor());
        this.paintText(text, x2, y2, (Function1<? super Shape, Unit>)((Function1)new Function1<Shape, Unit>((Object)this.graphics){

            public final void invoke(Shape p0) {
                ((Graphics2D)this.receiver).draw(p0);
            }
        }));
    }

    @Override
    public void scale(double xy2) {
        this.scale(xy2, xy2);
    }

    @Override
    public void fillText(@NotNull String text, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.graphics.setColor(this.state.getFillColor());
        this.paintText(text, x2, y2, (Function1<? super Shape, Unit>)((Function1)new Function1<Shape, Unit>((Object)this.graphics){

            public final void invoke(Shape p0) {
                ((Graphics2D)this.receiver).fill(p0);
            }
        }));
    }

    @Override
    public void scale(double x2, double y2) {
        this.graphics.scale(x2, y2);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"graphics.transform");
        this.state.setTransform(affineTransform);
    }

    @Override
    public void rotate(double angle) {
        this.graphics.rotate(angle);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"graphics.transform");
        this.state.setTransform(affineTransform);
    }

    @Override
    public void translate(double x2, double y2) {
        this.graphics.translate(x2, y2);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"graphics.transform");
        this.state.setTransform(affineTransform);
    }

    @Override
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.graphics.transform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"graphics.transform");
        this.state.setTransform(affineTransform);
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        block0: {
            GeneralPath generalPath = this.currentPath;
            if (generalPath == null) break block0;
            generalPath.curveTo(cp1x, cp1y, cp2x, cp2y, x2, y2);
        }
    }

    @Override
    public void setLineJoin(@NotNull LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineJoin), (String)"lineJoin");
        this.state.setStroke(AwtContext2d.change$default(this, this.state.getStroke(), 0.0f, this.convertLineJoin(lineJoin), 0, 0.0f, null, 0.0f, 61, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    @Override
    public void setLineCap(@NotNull LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineCap), (String)"lineCap");
        this.state.setStroke(AwtContext2d.change$default(this, this.state.getStroke(), 0.0f, 0, this.convertLineCap(lineCap), 0.0f, null, 0.0f, 59, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    @Override
    public void setTextBaseline(@NotNull TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        this.state.setTextBaseline(baseline);
    }

    @Override
    public void setTextAlign(@NotNull TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        this.state.setTextAlign(align);
    }

    @Override
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.graphics.setTransform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"graphics.transform");
        this.state.setTransform(affineTransform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLineDash(@NotNull double[] lineDash) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        ContextState contextState = this.state;
        AwtContext2d awtContext2d = this;
        BasicStroke basicStroke = this.state.getStroke();
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        float f2 = 0.0f;
        if (lineDash.length == 0) {
            fArray = null;
        } else {
            Collection<Float> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            double[] dArray = lineDash;
            float f3 = f2;
            int n3 = n2;
            int n4 = n;
            float f4 = f;
            BasicStroke basicStroke2 = basicStroke;
            AwtContext2d awtContext2d2 = awtContext2d;
            ContextState contextState2 = contextState;
            boolean $i$f$map = false;
            void var4_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n5 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n5; ++i) {
                void p0;
                void item$iv$iv;
                void var11_17 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf((float)p0));
            }
            collection = (List)destination$iv$iv;
            contextState = contextState2;
            awtContext2d = awtContext2d2;
            basicStroke = basicStroke2;
            f = f4;
            n = n4;
            n2 = n3;
            f2 = f3;
            fArray = CollectionsKt.toFloatArray((Collection)collection);
        }
        contextState.setStroke(AwtContext2d.change$default(awtContext2d, basicStroke, f, n, n2, f2, fArray, 0.0f, 47, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    @Override
    public double measureText(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.glyphVector(this.graphics, str).getVisualBounds().getWidth();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BY\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\f\b\u0002\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0006H\u00c6\u0003J\t\u00104\u001a\u00020\bH\u00c6\u0003J\t\u00105\u001a\u00020\nH\u00c6\u0003J\r\u00106\u001a\u00060\fj\u0002`\rH\u00c6\u0003J\t\u00107\u001a\u00020\u000fH\u00c6\u0003J\t\u00108\u001a\u00020\u0011H\u00c6\u0003J]\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\f\b\u0002\u0010\u000b\u001a\u00060\fj\u0002`\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010=\u001a\u00020>H\u00d6\u0001J\t\u0010?\u001a\u00020@H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006A"}, d2={"Ljetbrains/datalore/vis/canvas/awt/AwtContext2d$ContextState;", "", "strokeColor", "Ljava/awt/Color;", "fillColor", "stroke", "Ljava/awt/BasicStroke;", "textBaseline", "Ljetbrains/datalore/vis/canvas/TextBaseline;", "textAlign", "Ljetbrains/datalore/vis/canvas/TextAlign;", "font", "Ljava/awt/Font;", "Ljetbrains/datalore/vis/canvas/awt/AwtFont;", "globalAlpha", "", "transform", "Ljava/awt/geom/AffineTransform;", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/BasicStroke;Ljetbrains/datalore/vis/canvas/TextBaseline;Ljetbrains/datalore/vis/canvas/TextAlign;Ljava/awt/Font;FLjava/awt/geom/AffineTransform;)V", "getFillColor", "()Ljava/awt/Color;", "setFillColor", "(Ljava/awt/Color;)V", "getFont", "()Ljava/awt/Font;", "setFont", "(Ljava/awt/Font;)V", "getGlobalAlpha", "()F", "setGlobalAlpha", "(F)V", "getStroke", "()Ljava/awt/BasicStroke;", "setStroke", "(Ljava/awt/BasicStroke;)V", "getStrokeColor", "setStrokeColor", "getTextAlign", "()Ljetbrains/datalore/vis/canvas/TextAlign;", "setTextAlign", "(Ljetbrains/datalore/vis/canvas/TextAlign;)V", "getTextBaseline", "()Ljetbrains/datalore/vis/canvas/TextBaseline;", "setTextBaseline", "(Ljetbrains/datalore/vis/canvas/TextBaseline;)V", "getTransform", "()Ljava/awt/geom/AffineTransform;", "setTransform", "(Ljava/awt/geom/AffineTransform;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vis-canvas"})
    private static final class ContextState {
        @NotNull
        private Color strokeColor;
        @NotNull
        private Color fillColor;
        @NotNull
        private BasicStroke stroke;
        @NotNull
        private TextBaseline textBaseline;
        @NotNull
        private TextAlign textAlign;
        @NotNull
        private java.awt.Font font;
        private float globalAlpha;
        @NotNull
        private AffineTransform transform;

        public ContextState(@NotNull Color strokeColor, @NotNull Color fillColor, @NotNull BasicStroke stroke, @NotNull TextBaseline textBaseline, @NotNull TextAlign textAlign, @NotNull java.awt.Font font, float globalAlpha, @NotNull AffineTransform transform2) {
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter((Object)((Object)textBaseline), (String)"textBaseline");
            Intrinsics.checkNotNullParameter((Object)((Object)textAlign), (String)"textAlign");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            this.strokeColor = strokeColor;
            this.fillColor = fillColor;
            this.stroke = stroke;
            this.textBaseline = textBaseline;
            this.textAlign = textAlign;
            this.font = font;
            this.globalAlpha = globalAlpha;
            this.transform = transform2;
        }

        public /* synthetic */ ContextState(Color color, Color color2, BasicStroke basicStroke, TextBaseline textBaseline, TextAlign textAlign, java.awt.Font font, float f, AffineTransform affineTransform, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Color color3 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"BLACK");
                color = color3;
            }
            if ((n & 2) != 0) {
                Color color4 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"BLACK");
                color2 = color4;
            }
            if ((n & 4) != 0) {
                basicStroke = new BasicStroke();
            }
            if ((n & 8) != 0) {
                textBaseline = TextBaseline.ALPHABETIC;
            }
            if ((n & 0x10) != 0) {
                textAlign = TextAlign.START;
            }
            if ((n & 0x20) != 0) {
                font = new java.awt.Font("Serif", 0, 10);
            }
            if ((n & 0x40) != 0) {
                f = 1.0f;
            }
            if ((n & 0x80) != 0) {
                affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            }
            this(color, color2, basicStroke, textBaseline, textAlign, font, f, affineTransform);
        }

        @NotNull
        public final Color getStrokeColor() {
            return this.strokeColor;
        }

        public final void setStrokeColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.strokeColor = color;
        }

        @NotNull
        public final Color getFillColor() {
            return this.fillColor;
        }

        public final void setFillColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.fillColor = color;
        }

        @NotNull
        public final BasicStroke getStroke() {
            return this.stroke;
        }

        public final void setStroke(@NotNull BasicStroke basicStroke) {
            Intrinsics.checkNotNullParameter((Object)basicStroke, (String)"<set-?>");
            this.stroke = basicStroke;
        }

        @NotNull
        public final TextBaseline getTextBaseline() {
            return this.textBaseline;
        }

        public final void setTextBaseline(@NotNull TextBaseline textBaseline) {
            Intrinsics.checkNotNullParameter((Object)((Object)textBaseline), (String)"<set-?>");
            this.textBaseline = textBaseline;
        }

        @NotNull
        public final TextAlign getTextAlign() {
            return this.textAlign;
        }

        public final void setTextAlign(@NotNull TextAlign textAlign) {
            Intrinsics.checkNotNullParameter((Object)((Object)textAlign), (String)"<set-?>");
            this.textAlign = textAlign;
        }

        @NotNull
        public final java.awt.Font getFont() {
            return this.font;
        }

        public final void setFont(@NotNull java.awt.Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
            this.font = font;
        }

        public final float getGlobalAlpha() {
            return this.globalAlpha;
        }

        public final void setGlobalAlpha(float f) {
            this.globalAlpha = f;
        }

        @NotNull
        public final AffineTransform getTransform() {
            return this.transform;
        }

        public final void setTransform(@NotNull AffineTransform affineTransform) {
            Intrinsics.checkNotNullParameter((Object)affineTransform, (String)"<set-?>");
            this.transform = affineTransform;
        }

        @NotNull
        public final Color component1() {
            return this.strokeColor;
        }

        @NotNull
        public final Color component2() {
            return this.fillColor;
        }

        @NotNull
        public final BasicStroke component3() {
            return this.stroke;
        }

        @NotNull
        public final TextBaseline component4() {
            return this.textBaseline;
        }

        @NotNull
        public final TextAlign component5() {
            return this.textAlign;
        }

        @NotNull
        public final java.awt.Font component6() {
            return this.font;
        }

        public final float component7() {
            return this.globalAlpha;
        }

        @NotNull
        public final AffineTransform component8() {
            return this.transform;
        }

        @NotNull
        public final ContextState copy(@NotNull Color strokeColor, @NotNull Color fillColor, @NotNull BasicStroke stroke, @NotNull TextBaseline textBaseline, @NotNull TextAlign textAlign, @NotNull java.awt.Font font, float globalAlpha, @NotNull AffineTransform transform2) {
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter((Object)((Object)textBaseline), (String)"textBaseline");
            Intrinsics.checkNotNullParameter((Object)((Object)textAlign), (String)"textAlign");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            return new ContextState(strokeColor, fillColor, stroke, textBaseline, textAlign, font, globalAlpha, transform2);
        }

        public static /* synthetic */ ContextState copy$default(ContextState contextState, Color color, Color color2, BasicStroke basicStroke, TextBaseline textBaseline, TextAlign textAlign, java.awt.Font font, float f, AffineTransform affineTransform, int n, Object object) {
            if ((n & 1) != 0) {
                color = contextState.strokeColor;
            }
            if ((n & 2) != 0) {
                color2 = contextState.fillColor;
            }
            if ((n & 4) != 0) {
                basicStroke = contextState.stroke;
            }
            if ((n & 8) != 0) {
                textBaseline = contextState.textBaseline;
            }
            if ((n & 0x10) != 0) {
                textAlign = contextState.textAlign;
            }
            if ((n & 0x20) != 0) {
                font = contextState.font;
            }
            if ((n & 0x40) != 0) {
                f = contextState.globalAlpha;
            }
            if ((n & 0x80) != 0) {
                affineTransform = contextState.transform;
            }
            return contextState.copy(color, color2, basicStroke, textBaseline, textAlign, font, f, affineTransform);
        }

        @NotNull
        public String toString() {
            return "ContextState(strokeColor=" + this.strokeColor + ", fillColor=" + this.fillColor + ", stroke=" + this.stroke + ", textBaseline=" + (Object)((Object)this.textBaseline) + ", textAlign=" + (Object)((Object)this.textAlign) + ", font=" + this.font + ", globalAlpha=" + this.globalAlpha + ", transform=" + this.transform + ')';
        }

        public int hashCode() {
            int result2 = this.strokeColor.hashCode();
            result2 = result2 * 31 + this.fillColor.hashCode();
            result2 = result2 * 31 + this.stroke.hashCode();
            result2 = result2 * 31 + this.textBaseline.hashCode();
            result2 = result2 * 31 + this.textAlign.hashCode();
            result2 = result2 * 31 + this.font.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.globalAlpha);
            result2 = result2 * 31 + this.transform.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextState)) {
                return false;
            }
            ContextState contextState = (ContextState)other;
            if (!Intrinsics.areEqual((Object)this.strokeColor, (Object)contextState.strokeColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fillColor, (Object)contextState.fillColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stroke, (Object)contextState.stroke)) {
                return false;
            }
            if (this.textBaseline != contextState.textBaseline) {
                return false;
            }
            if (this.textAlign != contextState.textAlign) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.font, (Object)contextState.font)) {
                return false;
            }
            if (Float.compare(this.globalAlpha, contextState.globalAlpha) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.transform, (Object)contextState.transform);
        }

        public ContextState() {
            this(null, null, null, null, null, null, 0.0f, null, 255, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[LineJoin.values().length];
            try {
                nArray[LineJoin.BEVEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineJoin.MITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineJoin.ROUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LineCap.values().length];
            try {
                nArray[LineCap.BUTT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineCap.ROUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineCap.SQUARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[TextBaseline.values().length];
            try {
                nArray[TextBaseline.ALPHABETIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[FontWeight.values().length];
            try {
                nArray[FontWeight.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontWeight.BOLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[FontStyle.values().length];
            try {
                nArray[FontStyle.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.ITALIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

