/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.scale.provider;

import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.DiscreteTransform;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.scale.MapperUtil;
import jetbrains.datalore.plot.builder.scale.GuideMapper;
import jetbrains.datalore.plot.builder.scale.mapper.GuideMappers;
import jetbrains.datalore.plot.builder.scale.provider.ColorBrewerMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.MapperProviderBase;
import jetbrains.datalore.plot.common.color.ColorPalette;
import jetbrains.datalore.plot.common.color.ColorScheme;
import jetbrains.datalore.plot.common.color.PaletteUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/builder/scale/provider/ColorBrewerMapperProvider;", "Ljetbrains/datalore/plot/builder/scale/provider/MapperProviderBase;", "Ljetbrains/datalore/base/values/Color;", "paletteTypeName", "", "paletteNameOrIndex", "", "direction", "", "naValue", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Double;Ljetbrains/datalore/base/values/Color;)V", "Ljava/lang/Double;", "colorScheme", "Ljetbrains/datalore/plot/common/color/ColorScheme;", "discrete", "", "colorCount", "", "(ZLjava/lang/Integer;)Ljetbrains/datalore/plot/common/color/ColorScheme;", "colors", "", "count", "createContinuousMapper", "Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "trans", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "createDiscreteMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "discreteTransform", "Ljetbrains/datalore/plot/base/DiscreteTransform;", "Companion", "plot-builder-portable"})
public final class ColorBrewerMapperProvider
extends MapperProviderBase<Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String paletteTypeName;
    @Nullable
    private final Object paletteNameOrIndex;
    @Nullable
    private final Double direction;

    public ColorBrewerMapperProvider(@Nullable String paletteTypeName, @Nullable Object paletteNameOrIndex, @Nullable Double direction, @NotNull Color naValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
        this.paletteTypeName = paletteTypeName;
        this.paletteNameOrIndex = paletteNameOrIndex;
        this.direction = direction;
        Object object = this.paletteNameOrIndex;
        if (object != null) {
            Object it = object;
            boolean bl2 = false;
            bl = this.paletteNameOrIndex instanceof String || this.paletteNameOrIndex instanceof Number;
        } else {
            bl = true;
        }
        if (!bl) {
            boolean $i$a$-require-ColorBrewerMapperProvider$42 = false;
            StringBuilder stringBuilder = new StringBuilder().append("palette: expected a name or index but was: ");
            Object object2 = this.paletteNameOrIndex;
            Intrinsics.checkNotNull((Object)object2);
            String $i$a$-require-ColorBrewerMapperProvider$42 = stringBuilder.append(Reflection.getOrCreateKotlinClass(object2.getClass()).getSimpleName()).toString();
            throw new IllegalArgumentException($i$a$-require-ColorBrewerMapperProvider$42.toString());
        }
        if (this.paletteNameOrIndex instanceof Number && !(this.paletteTypeName != null)) {
            boolean bl3 = false;
            String string = "brewer palette type required: 'seq', 'div' or 'qual'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public ScaleMapper<Color> createDiscreteMapper(@NotNull DiscreteTransform discreteTransform) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        int n = discreteTransform.getEffectiveDomain().size();
        ColorScheme colorScheme = this.colorScheme(true, n);
        List<Color> colors = this.colors(colorScheme, n);
        return GuideMappers.INSTANCE.discreteToDiscrete(discreteTransform, colors, this.getNaValue());
    }

    @Override
    @NotNull
    public GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull ContinuousTransform trans) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        ColorScheme colorScheme = ColorBrewerMapperProvider.colorScheme$default(this, false, null, 2, null);
        List<Color> colors = this.colors(colorScheme, colorScheme.getMaxColors());
        DoubleSpan domain2 = MapperUtil.INSTANCE.rangeWithLimitsAfterTransform(domain, trans);
        return GuideMappers.INSTANCE.continuousToDiscrete(domain2, colors, this.getNaValue());
    }

    private final List<Color> colors(ColorScheme colorScheme, int count2) {
        List<Color> list2;
        boolean bl;
        boolean bl2;
        List<Color> colors = PaletteUtil.INSTANCE.schemeColors(colorScheme, count2);
        Double d = this.direction;
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl3 = false;
            bl2 = this.direction < 0.0;
        } else {
            bl2 = bl = false;
        }
        if (bl) {
            list2 = CollectionsKt.reversed((Iterable)colors);
        } else if (!bl) {
            list2 = colors;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    private final ColorScheme colorScheme(boolean discrete2, Integer colorCount) {
        ColorPalette.Type type;
        if (this.paletteNameOrIndex instanceof String) {
            ColorPalette.Type palType = PaletteUtil.INSTANCE.paletteTypeByPaletteName((String)this.paletteNameOrIndex);
            if (!(palType != null)) {
                boolean bl = false;
                String string = ColorBrewerMapperProvider.Companion.cantFindPaletteError((String)this.paletteNameOrIndex);
                throw new IllegalArgumentException(string.toString());
            }
            type = palType;
        } else {
            type = this.paletteTypeName != null ? ColorBrewerMapperProvider.Companion.paletteType(this.paletteTypeName) : (discrete2 ? ColorPalette.Type.QUALITATIVE : ColorPalette.Type.SEQUENTIAL);
        }
        ColorPalette.Type paletteType = type;
        return this.paletteNameOrIndex instanceof Number ? PaletteUtil.INSTANCE.colorSchemeByIndex(paletteType, ((Number)this.paletteNameOrIndex).intValue()) : (this.paletteNameOrIndex instanceof String ? ColorBrewerMapperProvider.Companion.colorSchemeByName(paletteType, (String)this.paletteNameOrIndex) : (paletteType == ColorPalette.Type.QUALITATIVE ? (ColorScheme)(colorCount != null && colorCount <= ColorPalette.Qualitative.Set2.getMaxColors() ? ColorPalette.Qualitative.Set2 : ColorPalette.Qualitative.Set3) : PaletteUtil.INSTANCE.colorSchemeByIndex(paletteType, 0)));
    }

    static /* synthetic */ ColorScheme colorScheme$default(ColorBrewerMapperProvider colorBrewerMapperProvider, boolean bl, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return colorBrewerMapperProvider.colorScheme(bl, n);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J+\u0010\n\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/scale/provider/ColorBrewerMapperProvider$Companion;", "", "()V", "cantFindPaletteError", "", "paletteName", "colorSchemeByName", "Ljetbrains/datalore/plot/common/color/ColorScheme;", "paletteType", "Ljetbrains/datalore/plot/common/color/ColorPalette$Type;", "names", "T", "", "enums", "", "([Ljava/lang/Enum;)Ljava/lang/String;", "name", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final ColorPalette.Type paletteType(String name) {
            ColorPalette.Type type;
            block7: {
                if (name == null) {
                    return ColorPalette.Type.SEQUENTIAL;
                }
                String string = name;
                switch (string.hashCode()) {
                    case 99473: {
                        if (string.equals("div")) break;
                        throw new IllegalArgumentException("Palette type expected one of 'seq' (sequential), 'div' (diverging) or 'qual' (qualitative) but was: '" + name + '\'');
                    }
                    case 3481935: {
                        if (!string.equals("qual")) {
                            throw new IllegalArgumentException("Palette type expected one of 'seq' (sequential), 'div' (diverging) or 'qual' (qualitative) but was: '" + name + '\'');
                        }
                        break block7;
                    }
                    case 113759: {
                        if (!string.equals("seq")) throw new IllegalArgumentException("Palette type expected one of 'seq' (sequential), 'div' (diverging) or 'qual' (qualitative) but was: '" + name + '\'');
                        type = ColorPalette.Type.SEQUENTIAL;
                        return type;
                    }
                }
                type = ColorPalette.Type.DIVERGING;
                return type;
            }
            type = ColorPalette.Type.QUALITATIVE;
            return type;
            throw new IllegalArgumentException("Palette type expected one of 'seq' (sequential), 'div' (diverging) or 'qual' (qualitative) but was: '" + name + '\'');
        }

        private final ColorScheme colorSchemeByName(ColorPalette.Type paletteType, String paletteName) {
            try {
                ColorScheme colorScheme;
                switch (WhenMappings.$EnumSwitchMapping$0[paletteType.ordinal()]) {
                    case 1: {
                        colorScheme = ColorPalette.Sequential.valueOf(paletteName);
                        break;
                    }
                    case 2: {
                        colorScheme = ColorPalette.Diverging.valueOf(paletteName);
                        break;
                    }
                    case 3: {
                        colorScheme = ColorPalette.Qualitative.valueOf(paletteName);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return colorScheme;
            }
            catch (IllegalArgumentException ignore) {
                throw new IllegalArgumentException(this.cantFindPaletteError(paletteName));
            }
        }

        private final String cantFindPaletteError(String paletteName) {
            return StringsKt.trimMargin$default((String)("\n                |Brewer palette '" + paletteName + "' was not found. \n                |Valid palette names are: \n                |   Type 'seq' (sequential): \n                |       " + this.names(ColorPalette.Sequential.values()) + "       \n                |   Type 'div' (diverging): \n                |       " + this.names(ColorPalette.Diverging.values()) + "       \n                |   Type 'qual' (qualitative): \n                |       " + this.names(ColorPalette.Qualitative.values()) + "       \n            "), null, (int)1, null);
        }

        private final <T extends Enum<T>> String names(T[] enums) {
            return ArraysKt.joinToString$default((Object[])enums, (CharSequence)", ", null, null, (int)0, null, (Function1)names.1.INSTANCE, (int)30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorPalette.Type.values().length];
                try {
                    nArray[ColorPalette.Type.SEQUENTIAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorPalette.Type.DIVERGING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorPalette.Type.QUALITATIVE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

