/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.List;
import java.util.Set;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.sampling.method.GroupSamplingBase;
import jetbrains.datalore.plot.builder.sampling.method.SamplingUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/GroupRandomSampling;", "Ljetbrains/datalore/plot/builder/sampling/method/GroupSamplingBase;", "sampleSize", "", "mySeed", "", "(ILjava/lang/Long;)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "Ljava/lang/Long;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "population", "groupMapper", "Lkotlin/Function1;", "createRandom", "Lkotlin/random/Random;", "Companion", "plot-builder-portable"})
public final class GroupRandomSampling
extends GroupSamplingBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long mySeed;
    @NotNull
    public static final String ALIAS = "group_random";

    public GroupRandomSampling(int sampleSize, @Nullable Long mySeed) {
        super(sampleSize);
        this.mySeed = mySeed;
    }

    @Override
    @NotNull
    public String getExpressionText() {
        return "sampling_group_random(n=" + this.getSampleSize() + (this.mySeed != null ? ", seed=" + this.mySeed : "") + ')';
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        if (!this.isApplicable(population, groupMapper2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<Integer> distinctGroups = SamplingUtil.INSTANCE.distinctGroups(groupMapper2, population.rowCount());
        CollectionsKt.shuffle(distinctGroups, (Random)this.createRandom());
        Set pickedGroups = CollectionsKt.toSet((Iterable)CollectionsKt.take((Iterable)distinctGroups, (int)this.getSampleSize()));
        return this.doSelect(population, pickedGroups, groupMapper2);
    }

    private final Random createRandom() {
        Long l;
        block3: {
            block2: {
                l = this.mySeed;
                if (l == null) break block2;
                long it = ((Number)l).longValue();
                boolean bl = false;
                Random random = RandomKt.Random((long)it);
                l = random;
                if (random != null) break block3;
            }
            l = (Random)Random.Default;
        }
        return l;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/GroupRandomSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

