/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.figure.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.FigureBuildInfo;
import jetbrains.datalore.plot.builder.layout.figure.composite.FigureGridLayoutUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\t\u00a2\u0006\u0002\u0010\u000fJ.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00032\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tH\u0002J(\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\t2\u0006\u0010\u0019\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\tH\u0004R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/layout/figure/composite/CompositeFigureGridLayoutBase;", "", "ncols", "", "nrows", "hSpace", "", "vSpace", "colWidths", "", "rowHeights", "fitCellAspectRatio", "", "elementsDefaultSizes", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(IIDDLjava/util/List;Ljava/util/List;ZLjava/util/List;)V", "getNcols", "()I", "getNrows", "cellSizeList", "totalSize", "n", "sizeList", "toElelemtsWithInitialBounds", "Ljetbrains/datalore/plot/builder/FigureBuildInfo;", "size", "elements", "plot-builder-portable"})
public abstract class CompositeFigureGridLayoutBase {
    private final int ncols;
    private final int nrows;
    private final double hSpace;
    private final double vSpace;
    @Nullable
    private final List<Double> colWidths;
    @Nullable
    private final List<Double> rowHeights;
    private final boolean fitCellAspectRatio;
    @NotNull
    private final List<DoubleVector> elementsDefaultSizes;

    public CompositeFigureGridLayoutBase(int ncols, int nrows, double hSpace, double vSpace, @Nullable List<Double> colWidths, @Nullable List<Double> rowHeights, boolean fitCellAspectRatio, @NotNull List<DoubleVector> elementsDefaultSizes) {
        Intrinsics.checkNotNullParameter(elementsDefaultSizes, (String)"elementsDefaultSizes");
        this.ncols = ncols;
        this.nrows = nrows;
        this.hSpace = hSpace;
        this.vSpace = vSpace;
        this.colWidths = colWidths;
        this.rowHeights = rowHeights;
        this.fitCellAspectRatio = fitCellAspectRatio;
        this.elementsDefaultSizes = elementsDefaultSizes;
    }

    protected final int getNcols() {
        return this.ncols;
    }

    protected final int getNrows() {
        return this.nrows;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<FigureBuildInfo> toElelemtsWithInitialBounds(@NotNull DoubleVector size2, @NotNull List<? extends FigureBuildInfo> elements) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (!(this.ncols > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.nrows > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(elements.size() == this.nrows * this.ncols)) {
            boolean bl = false;
            String string = "Grid size mismatch: " + elements.size() + " elements in a " + this.ncols + " X " + this.nrows + " grid.";
            throw new IllegalStateException(string.toString());
        }
        double hSpaceSum = this.hSpace * (double)(this.ncols - 1);
        double vSpaceSum = this.vSpace * (double)(this.nrows - 1);
        List<Double> cellWidthByCol = this.cellSizeList(size2.getX() - hSpaceSum, this.ncols, this.colWidths);
        List<Double> cellHeightByRow = this.cellSizeList(size2.getY() - vSpaceSum, this.nrows, this.rowHeights);
        Iterable $this$mapIndexed$iv = elements;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            FigureBuildInfo figureBuildInfo;
            void buildInfo;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FigureBuildInfo figureBuildInfo2 = (FigureBuildInfo)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int row = FigureGridLayoutUtil.INSTANCE.indexToRow((int)index, this.ncols);
            int col = FigureGridLayoutUtil.INSTANCE.indexToCol((int)index, this.ncols);
            DoubleRectangle cellBounds = new DoubleRectangle(FigureGridLayoutUtil.INSTANCE.toCellOrigin(col, cellWidthByCol, this.hSpace), FigureGridLayoutUtil.INSTANCE.toCellOrigin(row, cellHeightByRow, this.vSpace), ((Number)cellWidthByCol.get(col)).doubleValue(), ((Number)cellHeightByRow.get(row)).doubleValue());
            if (buildInfo != null) {
                void it;
                DoubleRectangle doubleRectangle;
                boolean bl2 = false;
                if (this.fitCellAspectRatio) {
                    doubleRectangle = cellBounds;
                } else {
                    DoubleVector figureDefaultSize;
                    Intrinsics.checkNotNull((Object)this.elementsDefaultSizes.get((int)index));
                    doubleRectangle = cellBounds.srinkToAspectRatio(figureDefaultSize);
                }
                DoubleRectangle figureBounds = doubleRectangle;
                figureBuildInfo = it.withBounds(figureBounds);
            } else {
                figureBuildInfo = null;
            }
            collection.add(figureBuildInfo);
        }
        return (List)destination$iv$iv;
    }

    private final List<Double> cellSizeList(double totalSize, int n, List<Double> sizeList) {
        double it;
        Iterable $this$mapTo$iv$iv;
        List list2;
        Collection<Double> collection;
        int n2;
        int n3;
        ArrayList<Double> arrayList = (ArrayList<Double>)sizeList;
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList<Double>(n);
            n3 = 0;
            while (n3 < n) {
                int n4 = n2 = n3++;
                collection = arrayList;
                boolean bl = false;
                ((ArrayList)collection).add(1.0);
            }
            list2 = arrayList;
        } else {
            collection = (ArrayList<Double>)sizeList;
            arrayList = new ArrayList(n);
            n3 = 0;
            while (n3 < n) {
                int it2 = n2 = n3++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(((Number)CollectionsKt.last(sizeList)).doubleValue());
            }
            list2 = CollectionsKt.take((Iterable)CollectionsKt.plus(collection, (Iterable)arrayList), (int)n);
        }
        List sizeList2 = list2;
        double sizeSum = CollectionsKt.sumOfDouble((Iterable)sizeList2);
        Iterable $this$map$iv = sizeList2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(it / sizeSum));
        }
        List sizeListNorm = (List)destination$iv$iv;
        $this$map$iv = sizeListNorm;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it * totalSize);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Math.max(it, 1.0));
        }
        return (List)destination$iv$iv;
    }
}

