/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.GeometryUtil;
import jetbrains.datalore.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 $2\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J<\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00150\u001fJ8\u0010 \u001a\u0004\u0018\u00010\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00150\u001fJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayout;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "getBreaks", "()Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "createAxisLabelsLayoutInfoBuilder", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo$Builder;", "bounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "overlap", "", "labelBounds", "labelNormalSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "labelLocation", "labelText", "", "labelBoundsList", "", "tickPositions", "", "tickLabels", "toTickLocation", "Lkotlin/Function1;", "labelsBounds", "noLabelsLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "Companion", "plot-builder-portable"})
public abstract class AbstractFixedBreaksLabelsLayout
extends AxisLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScaleBreaks breaks;
    @NotNull
    private static final Function1<Double, DoubleVector> HORIZONTAL_TICK_LOCATION = Companion.HORIZONTAL_TICK_LOCATION.1.INSTANCE;

    public AbstractFixedBreaksLabelsLayout(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, theme);
        this.breaks = breaks;
    }

    @NotNull
    protected final ScaleBreaks getBreaks() {
        return this.breaks;
    }

    private final DoubleRectangle labelBounds(DoubleVector labelLocation, String labelText) {
        DoubleVector dim = this.getLabelSpec().dimensions(labelText);
        DoubleRectangle labelBounds = this.labelBounds(dim);
        return labelBounds.add(labelLocation);
    }

    @NotNull
    protected abstract DoubleRectangle labelBounds(@NotNull DoubleVector var1);

    @Nullable
    public final DoubleRectangle labelsBounds(@NotNull List<Double> tickPositions, @NotNull List<String> tickLabels, @NotNull Function1<? super Double, DoubleVector> toTickLocation) {
        Intrinsics.checkNotNullParameter(tickPositions, (String)"tickPositions");
        Intrinsics.checkNotNullParameter(tickLabels, (String)"tickLabels");
        Intrinsics.checkNotNullParameter(toTickLocation, (String)"toTickLocation");
        List<DoubleRectangle> boundsList = this.labelBoundsList(tickPositions, this.breaks.getLabels(), toTickLocation);
        DoubleRectangle bounds = null;
        for (DoubleRectangle labelBounds : boundsList) {
            bounds = GeometryUtil.INSTANCE.union(labelBounds, bounds);
        }
        return bounds;
    }

    @NotNull
    public final List<DoubleRectangle> labelBoundsList(@NotNull List<Double> tickPositions, @NotNull List<String> tickLabels, @NotNull Function1<? super Double, DoubleVector> toTickLocation) {
        Intrinsics.checkNotNullParameter(tickPositions, (String)"tickPositions");
        Intrinsics.checkNotNullParameter(tickLabels, (String)"tickLabels");
        Intrinsics.checkNotNullParameter(toTickLocation, (String)"toTickLocation");
        ArrayList<DoubleRectangle> result2 = new ArrayList<DoubleRectangle>();
        Iterator<String> labels = tickLabels.iterator();
        Iterator<Double> iterator2 = tickPositions.iterator();
        while (iterator2.hasNext()) {
            double pos = ((Number)iterator2.next()).doubleValue();
            String label = labels.next();
            DoubleRectangle bounds = this.labelBounds((DoubleVector)toTickLocation.invoke((Object)pos), label);
            result2.add(bounds);
        }
        return result2;
    }

    @NotNull
    public final AxisLabelsLayoutInfo.Builder createAxisLabelsLayoutInfoBuilder(@NotNull DoubleRectangle bounds, boolean overlap) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return new AxisLabelsLayoutInfo.Builder().breaks(this.breaks).bounds(this.applyLabelMargins$plot_builder_portable(bounds)).overlap(overlap);
    }

    @NotNull
    public final AxisLabelsLayoutInfo noLabelsLayoutInfo(double axisLength, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        if (orientation.isHorizontal()) {
            DoubleRectangle bounds = new DoubleRectangle(axisLength / (double)2, 0.0, 0.0, 0.0);
            if (this.getTheme().showTickMarks()) {
                bounds = this.applyLabelMargins$plot_builder_portable(bounds);
            }
            return new AxisLabelsLayoutInfo.Builder().breaks(this.breaks).bounds(bounds).overlap(false).labelAdditionalOffsets(null).labelHorizontalAnchor(Text.HorizontalAnchor.MIDDLE).labelVerticalAnchor(Text.VerticalAnchor.TOP).build();
        }
        throw new IllegalStateException("Not implemented for " + (Object)((Object)orientation));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout$Companion;", "", "()V", "HORIZONTAL_TICK_LOCATION", "Lkotlin/Function1;", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getHORIZONTAL_TICK_LOCATION", "()Lkotlin/jvm/functions/Function1;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Double, DoubleVector> getHORIZONTAL_TICK_LOCATION() {
            return HORIZONTAL_TICK_LOCATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

