/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.PlotContext;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.builder.assemble.ColorBarAssembler;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00172\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ0\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u001e0\u001d\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotGuidesAssemblerUtil;", "", "()V", "checkFitsColorBar", "", "aes", "Ljetbrains/datalore/plot/base/Aes;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "createColorBarAssembler", "Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler;", "scaleName", "", "transformedDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "scaleMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "Ljetbrains/datalore/base/values/Color;", "options", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "fitsColorBar", "", "mappedRenderedAesToCreateGuides", "", "layer", "Ljetbrains/datalore/plot/base/PlotContext$Layer;", "guideOptionsMap", "", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "plot-builder-portable"})
public final class PlotGuidesAssemblerUtil {
    @NotNull
    public static final PlotGuidesAssemblerUtil INSTANCE = new PlotGuidesAssemblerUtil();

    private PlotGuidesAssemblerUtil() {
    }

    @NotNull
    public final List<Aes<?>> mappedRenderedAesToCreateGuides(@NotNull PlotContext.Layer layer, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        if (layer.isLegendDisabled()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result2 = new ArrayList();
        for (Aes<?> aes : layer.renderedAes()) {
            if (Aes.Companion.noGuideNeeded(aes) || layer.hasConstant(aes) || !layer.hasBinding(aes) || guideOptionsMap.containsKey(aes) && guideOptionsMap.get(aes) == GuideOptions.Companion.getNONE()) continue;
            result2.add(aes);
        }
        return result2;
    }

    @NotNull
    public final ColorBarAssembler createColorBarAssembler(@NotNull String scaleName, @NotNull DoubleSpan transformedDomain, @NotNull Scale scale, @NotNull ScaleMapper<Color> scaleMapper2, @Nullable ColorBarOptions options, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)scaleName, (String)"scaleName");
        Intrinsics.checkNotNullParameter((Object)transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter(scaleMapper2, (String)"scaleMapper");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        ColorBarAssembler result2 = new ColorBarAssembler(scaleName, transformedDomain, scale, scaleMapper2, theme);
        result2.setOptions$plot_builder_portable(options);
        return result2;
    }

    public final boolean fitsColorBar(@NotNull Aes<?> aes, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return aes.isColor() && scale.isContinuous();
    }

    public final void checkFitsColorBar(@NotNull Aes<?> aes, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        if (!aes.isColor()) {
            boolean $i$a$-check-PlotGuidesAssemblerUtil$checkFitsColorBar$32 = false;
            String $i$a$-check-PlotGuidesAssemblerUtil$checkFitsColorBar$32 = "Color-bar is not applicable to " + aes + " aesthetic";
            throw new IllegalStateException($i$a$-check-PlotGuidesAssemblerUtil$checkFitsColorBar$32.toString());
        }
        if (!scale.isContinuous()) {
            boolean bl = false;
            String string = "Color-bar is only applicable when both domain and color palette are continuous";
            throw new IllegalStateException(string.toString());
        }
    }
}

