/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Font;
import jetbrains.datalore.base.values.FontFamily;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.annotations.Annotations;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.NullGeomTargetCollector;
import jetbrains.datalore.plot.builder.assemble.ImmutableGeomContext;
import jetbrains.datalore.plot.builder.presentation.FontFamilyRegistry;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u00020\u00012\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder;", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext$Builder;", "()V", "ctx", "Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder$MyGeomContext;", "(Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder$MyGeomContext;)V", "aesBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "aestheticMappers", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/ScaleMapper;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "annotations", "Ljetbrains/datalore/plot/base/annotations/Annotations;", "flipped", "", "fontFamilyRegistry", "Ljetbrains/datalore/plot/builder/presentation/FontFamilyRegistry;", "geomTargetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "build", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext;", "v", "MyGeomContext", "plot-builder-portable"})
public final class GeomContextBuilder
implements ImmutableGeomContext.Builder {
    private boolean flipped;
    @Nullable
    private Aesthetics aesthetics;
    @Nullable
    private Map<Aes<?>, ? extends ScaleMapper<?>> aestheticMappers;
    @Nullable
    private DoubleRectangle aesBounds;
    @NotNull
    private GeomTargetCollector geomTargetCollector = new NullGeomTargetCollector();
    @Nullable
    private FontFamilyRegistry fontFamilyRegistry;
    @Nullable
    private Annotations annotations;

    public GeomContextBuilder() {
    }

    private GeomContextBuilder(MyGeomContext ctx2) {
        this.flipped = ctx2.getFlipped();
        this.aesthetics = ctx2.getAesthetics();
        this.aestheticMappers = ctx2.getAestheticMappers();
        this.aesBounds = ctx2.get_aesBounds();
        this.geomTargetCollector = ctx2.getTargetCollector();
        this.annotations = ctx2.getAnnotations();
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder flipped(boolean flipped) {
        this.flipped = flipped;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aesthetics(@NotNull Aesthetics aesthetics) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        this.aesthetics = aesthetics;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aestheticMappers(@NotNull Map<Aes<?>, ? extends ScaleMapper<?>> aestheticMappers) {
        Intrinsics.checkNotNullParameter(aestheticMappers, (String)"aestheticMappers");
        this.aestheticMappers = aestheticMappers;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder aesBounds(@NotNull DoubleRectangle aesBounds) {
        Intrinsics.checkNotNullParameter((Object)aesBounds, (String)"aesBounds");
        this.aesBounds = aesBounds;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder geomTargetCollector(@NotNull GeomTargetCollector geomTargetCollector) {
        Intrinsics.checkNotNullParameter((Object)geomTargetCollector, (String)"geomTargetCollector");
        this.geomTargetCollector = geomTargetCollector;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder fontFamilyRegistry(@NotNull FontFamilyRegistry v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.fontFamilyRegistry = v;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext.Builder annotations(@Nullable Annotations annotations) {
        this.annotations = annotations;
        return this;
    }

    @Override
    @NotNull
    public ImmutableGeomContext build() {
        return new MyGeomContext(this);
    }

    public /* synthetic */ GeomContextBuilder(MyGeomContext ctx2, DefaultConstructorMarker $constructor_marker) {
        this(ctx2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0018H\u0016J\b\u0010*\u001a\u00020\u0006H\u0016J\u0016\u0010+\u001a\u00020'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0\u000bH\u0016J\u0014\u0010-\u001a\u00020\u00182\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR'\u0010\t\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder$MyGeomContext;", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext;", "b", "Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder;", "(Ljetbrains/datalore/plot/builder/assemble/GeomContextBuilder;)V", "_aesBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "get_aesBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "aestheticMappers", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/ScaleMapper;", "getAestheticMappers", "()Ljava/util/Map;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "getAesthetics", "()Ljetbrains/datalore/plot/base/Aesthetics;", "annotations", "Ljetbrains/datalore/plot/base/annotations/Annotations;", "getAnnotations", "()Ljetbrains/datalore/plot/base/annotations/Annotations;", "flipped", "", "getFlipped", "()Z", "fontFamilyRegistry", "Ljetbrains/datalore/plot/builder/presentation/FontFamilyRegistry;", "targetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "getTargetCollector", "()Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "estimateTextSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "text", "", "family", "size", "", "isBold", "isItalic", "getAesBounds", "getResolution", "aes", "isMappedAes", "with", "Ljetbrains/datalore/plot/builder/assemble/ImmutableGeomContext$Builder;", "withTargetCollector", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-builder-portable"})
    private static final class MyGeomContext
    implements ImmutableGeomContext {
        @Nullable
        private final Aesthetics aesthetics;
        @Nullable
        private final Map<Aes<?>, ScaleMapper<?>> aestheticMappers;
        @Nullable
        private final DoubleRectangle _aesBounds;
        private final boolean flipped;
        @NotNull
        private final GeomTargetCollector targetCollector;
        @Nullable
        private final Annotations annotations;
        @Nullable
        private final FontFamilyRegistry fontFamilyRegistry;

        public MyGeomContext(@NotNull GeomContextBuilder b2) {
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            this.aesthetics = b2.aesthetics;
            this.aestheticMappers = b2.aestheticMappers;
            this._aesBounds = b2.aesBounds;
            this.flipped = b2.flipped;
            this.targetCollector = b2.geomTargetCollector;
            this.annotations = b2.annotations;
            this.fontFamilyRegistry = b2.fontFamilyRegistry;
        }

        @Nullable
        public final Aesthetics getAesthetics() {
            return this.aesthetics;
        }

        @Nullable
        public final Map<Aes<?>, ScaleMapper<?>> getAestheticMappers() {
            return this.aestheticMappers;
        }

        @Nullable
        public final DoubleRectangle get_aesBounds() {
            return this._aesBounds;
        }

        @Override
        public boolean getFlipped() {
            return this.flipped;
        }

        @Override
        @NotNull
        public GeomTargetCollector getTargetCollector() {
            return this.targetCollector;
        }

        @Override
        @Nullable
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Override
        public double getResolution(@NotNull Aes<Double> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            double resolution = 0.0;
            if (this.aesthetics != null) {
                resolution = this.aesthetics.resolution(aes, 0.0);
            }
            if (resolution <= 1.0E-50) {
                resolution = 1.0;
            }
            return resolution;
        }

        @Override
        public boolean isMappedAes(@NotNull Aes<?> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            Map<Aes<?>, ScaleMapper<?>> map2 = this.aestheticMappers;
            return map2 != null ? map2.containsKey(aes) : false;
        }

        @Override
        @NotNull
        public DoubleVector estimateTextSize(@NotNull String text, @NotNull String family, double size2, boolean isBold, boolean isItalic) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            FontFamilyRegistry registry = this.fontFamilyRegistry;
            if (!(registry != null)) {
                boolean bl = false;
                String string = "Font-family registry is not specified.";
                throw new IllegalStateException(string.toString());
            }
            FontFamily family2 = registry.get(family);
            return new PlotLabelSpec(new Font(family2, (int)size2, isBold, isItalic)).dimensions(text);
        }

        @Override
        @NotNull
        public DoubleRectangle getAesBounds() {
            if (!(this._aesBounds != null)) {
                boolean bl = false;
                String string = "GeomContext: aesthetics bounds are not defined.";
                throw new IllegalStateException(string.toString());
            }
            return this._aesBounds;
        }

        @Override
        @NotNull
        public GeomContext withTargetCollector(@NotNull GeomTargetCollector targetCollector) {
            Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
            return this.with().geomTargetCollector(targetCollector).build();
        }

        @Override
        @NotNull
        public ImmutableGeomContext.Builder with() {
            return new GeomContextBuilder(this, null);
        }
    }
}

