/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunctionKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/ForsythePolynomialGenerator;", "", "knots", "", "([D)V", "ps", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "Lkotlin/collections/ArrayList;", "alphaBeta", "Lkotlin/Pair;", "", "i", "", "getPolynomial", "n", "Companion", "plot-base-portable"})
public final class ForsythePolynomialGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] knots;
    @NotNull
    private final ArrayList<PolynomialFunction> ps;
    @NotNull
    private static final PolynomialFunction X;

    public ForsythePolynomialGenerator(@NotNull double[] knots) {
        Intrinsics.checkNotNullParameter((Object)knots, (String)"knots");
        this.knots = knots;
        if (!(!(this.knots.length == 0))) {
            boolean bl = false;
            String string = "The knots list must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new PolynomialFunction[2];
        double[] dArray = new double[]{1.0};
        objectArray[0] = new PolynomialFunction(dArray);
        dArray = new double[]{-ArraysKt.average((double[])this.knots), 1.0};
        objectArray[1] = new PolynomialFunction(dArray);
        this.ps = CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private final Pair<Double, Double> alphaBeta(int i) {
        if (!(i == this.ps.size())) {
            boolean $i$a$-require-ForsythePolynomialGenerator$alphaBeta$22 = false;
            String $i$a$-require-ForsythePolynomialGenerator$alphaBeta$22 = "Alpha must be calculated sequentially.";
            throw new IllegalArgumentException($i$a$-require-ForsythePolynomialGenerator$alphaBeta$22.toString());
        }
        PolynomialFunction p = (PolynomialFunction)CollectionsKt.last((List)this.ps);
        PolynomialFunction polynomialFunction = this.ps.get(this.ps.size() - 2);
        Intrinsics.checkNotNullExpressionValue((Object)polynomialFunction, (String)"ps[ps.size - 2]");
        PolynomialFunction pp = polynomialFunction;
        double sxp = 0.0;
        double sp2 = 0.0;
        double spp2 = 0.0;
        for (double x2 : this.knots) {
            double pv2 = Math.pow(p.value(x2), 2);
            double ppv2 = Math.pow(pp.value(x2), 2);
            sxp += x2 * pv2;
            sp2 += pv2;
            spp2 += ppv2;
        }
        return new Pair((Object)(sxp / sp2), (Object)(sp2 / spp2));
    }

    @NotNull
    public final PolynomialFunction getPolynomial(int n) {
        int n2;
        int sz;
        int k;
        if (!(n >= 0)) {
            boolean $i$a$-require-ForsythePolynomialGenerator$getPolynomial$32 = false;
            String $i$a$-require-ForsythePolynomialGenerator$getPolynomial$32 = "Degree of Forsythe polynomial must not be negative";
            throw new IllegalArgumentException($i$a$-require-ForsythePolynomialGenerator$getPolynomial$32.toString());
        }
        if (!(n < this.knots.length)) {
            boolean $i$a$-require-ForsythePolynomialGenerator$getPolynomial$42 = false;
            String $i$a$-require-ForsythePolynomialGenerator$getPolynomial$42 = "Degree of Forsythe polynomial must not exceed knots.size - 1";
            throw new IllegalArgumentException($i$a$-require-ForsythePolynomialGenerator$getPolynomial$42.toString());
        }
        if (n >= this.ps.size() && (k = (sz = this.ps.size())) <= (n2 = n + 1)) {
            while (true) {
                PolynomialFunction pPrevPrev;
                Pair<Double, Double> pair2 = this.alphaBeta(k);
                double a2 = ((Number)pair2.component1()).doubleValue();
                double b2 = ((Number)pair2.component2()).doubleValue();
                PolynomialFunction pPrev = (PolynomialFunction)CollectionsKt.last((List)this.ps);
                Intrinsics.checkNotNullExpressionValue((Object)this.ps.get(this.ps.size() - 2), (String)"ps[ps.size - 2]");
                PolynomialFunction p = X.times(pPrev).minus(PolynomialFunctionKt.times(a2, pPrev)).minus(PolynomialFunctionKt.times(b2, pPrevPrev));
                this.ps.add(p);
                if (k == n2) break;
                ++k;
            }
        }
        PolynomialFunction polynomialFunction = this.ps.get(n);
        Intrinsics.checkNotNullExpressionValue((Object)polynomialFunction, (String)"ps[n]");
        return polynomialFunction;
    }

    static {
        double[] dArray = new double[]{0.0, 1.0};
        X = new PolynomialFunction(dArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/ForsythePolynomialGenerator$Companion;", "", "()V", "X", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "getX", "()Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolynomialFunction getX() {
            return X;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

