/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.RectTargetCollectorHelper;
import jetbrains.datalore.plot.base.geom.util.RectanglesHelper;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.slim.SvgSlimGroup;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/geom/TileGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public class TileGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        RectanglesHelper helper = new RectanglesHelper(aesthetics, pos, coord, ctx2);
        SvgSlimGroup slimGroup = helper.createSlimRectangles((Function1<? super DataPointAesthetics, DoubleRectangle>)TileGeom.Companion.clientRectByDataPoint(ctx2, geomHelper));
        root.add(GeomBase.Companion.wrap(slimGroup));
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.TILE, ctx2);
        new RectTargetCollectorHelper(helper, (Function1<? super DataPointAesthetics, DoubleRectangle>)TileGeom.Companion.clientRectByDataPoint(ctx2, geomHelper), TipLayoutHint.Kind.CURSOR_TOOLTIP, colorsByDataPoint).collectTo(ctx2.getTargetCollector());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/geom/TileGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "clientRectByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2, geomHelper){
                final /* synthetic */ GeomContext $ctx;
                final /* synthetic */ GeomHelper $geomHelper;
                {
                    this.$ctx = $ctx;
                    this.$geomHelper = $geomHelper;
                    super(1);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                    DoubleRectangle doubleRectangle;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Double x2 = p.x();
                    Double y2 = p.y();
                    Double w = p.width();
                    Double h = p.height();
                    if (SeriesUtil.INSTANCE.allFinite(x2, y2, w, h)) {
                        Double d = w;
                        Intrinsics.checkNotNull((Object)d);
                        double width2 = d * this.$ctx.getResolution(Aes.Companion.getX());
                        Double d2 = h;
                        Intrinsics.checkNotNull((Object)d2);
                        double height = d2 * this.$ctx.getResolution(Aes.Companion.getY());
                        Double d3 = x2;
                        Intrinsics.checkNotNull((Object)d3);
                        double d4 = d3 - width2 / (double)2;
                        Double d5 = y2;
                        Intrinsics.checkNotNull((Object)d5);
                        DoubleVector origin = new DoubleVector(d4, d5 - height / (double)2);
                        DoubleVector dimensions = new DoubleVector(width2, height);
                        doubleRectangle = this.$geomHelper.toClient(new DoubleRectangle(origin, dimensions), p);
                    } else {
                        doubleRectangle = null;
                    }
                    return doubleRectangle;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

