/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.CompositeFigureConfig;
import jetbrains.datalore.plot.config.FigKind;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PlotConfig;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ1\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u00132\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u001a\u0010\"\u001a\u0004\u0018\u00010\n2\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0002J\u0016\u0010$\u001a\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0002J\u001a\u0010$\u001a\u00020\n2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007J6\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0018JI\u0010-\u001a\u00020\n2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010/J)\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u00102\u00a8\u00063"}, d2={"Ljetbrains/datalore/plot/PlotSizeHelper;", "", "()V", "bunchItemBoundsList", "", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "bunchSpec", "", "", "bunchItemSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "bunchItem", "Ljetbrains/datalore/plot/config/BunchConfig$BunchItem;", "bunchItemSize$plot_config_portable", "compositeFigureSize", "config", "Ljetbrains/datalore/plot/config/CompositeFigureConfig;", "plotSize", "plotMaxWidth", "", "plotPreferredWidth", "(Ljetbrains/datalore/plot/config/CompositeFigureConfig;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/base/geometry/DoubleVector;", "defaulPlotPanelGridSize", "ncol", "", "nrow", "defaultPlotGridSize", "defaultSinglePlotSize", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "containsLiveMap", "", "figureAspectRatio", "figureFpec", "getSizeOptionOrNull", "singlePlotSpec", "plotBunchSize", "bunchItemBoundsIterable", "", "plotBunchFpec", "scaledFigureSize", "Lkotlin/Pair;", "figureSpec", "containerWidth", "containerHeight", "singlePlotSize", "plotSpec", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;Ljetbrains/datalore/plot/builder/assemble/PlotFacets;Z)Ljetbrains/datalore/base/geometry/DoubleVector;", "toScaledSize", "size", "(Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-config-portable"})
public final class PlotSizeHelper {
    @NotNull
    public static final PlotSizeHelper INSTANCE = new PlotSizeHelper();

    private PlotSizeHelper() {
    }

    @NotNull
    public final Pair<Integer, Integer> scaledFigureSize(@NotNull Map<String, ? extends Object> figureSpec, int containerWidth, int containerHeight) {
        Pair pair2;
        Intrinsics.checkNotNullParameter(figureSpec, (String)"figureSpec");
        if (PlotConfig.Companion.isFailure(figureSpec)) {
            return new Pair((Object)containerWidth, (Object)containerHeight);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figureSpec).ordinal()]) {
            case 1: {
                DoubleVector bunchSize = this.plotBunchSize(figureSpec);
                pair2 = new Pair((Object)((int)Math.ceil(bunchSize.getX())), (Object)((int)Math.ceil(bunchSize.getY())));
                break;
            }
            case 2: 
            case 3: {
                double aspectRatio = this.figureAspectRatio(figureSpec);
                if (aspectRatio >= 1.0) {
                    double plotHeight = (double)containerWidth / aspectRatio;
                    double scaling = plotHeight > (double)containerHeight ? (double)containerHeight / plotHeight : 1.0;
                    pair2 = new Pair((Object)((int)Math.floor((double)containerWidth * scaling)), (Object)((int)Math.floor(plotHeight * scaling)));
                    break;
                }
                double plotWidth = (double)containerHeight * aspectRatio;
                double scaling = plotWidth > (double)containerWidth ? (double)containerWidth / plotWidth : 1.0;
                pair2 = new Pair((Object)((int)Math.floor(plotWidth * scaling)), (Object)((int)Math.floor((double)containerHeight * scaling)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair2;
    }

    @NotNull
    public final DoubleVector singlePlotSize(@NotNull Map<?, ?> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @Nullable Double plotPreferredWidth, @NotNull PlotFacets facets, boolean containsLiveMap) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        if (plotSize2 != null) {
            return plotSize2;
        }
        DoubleVector doubleVector = this.getSizeOptionOrNull(plotSpec);
        if (doubleVector == null) {
            doubleVector = this.defaultSinglePlotSize(facets, containsLiveMap);
        }
        DoubleVector defaultSize = doubleVector;
        return this.toScaledSize(defaultSize, plotMaxWidth, plotPreferredWidth);
    }

    @NotNull
    public final DoubleVector compositeFigureSize(@NotNull CompositeFigureConfig config2, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @Nullable Double plotPreferredWidth) {
        Object object;
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                if (plotSize2 != null) {
                    return plotSize2;
                }
                Pair<Integer, Integer> specifiedFigureSize = this.getSizeOptionOrNull(config2.toMap());
                object = specifiedFigureSize;
                if (object != null) break block4;
                PlotSizeHelper $this$compositeFigureSize_u24lambda_u241 = this;
                boolean bl = false;
                Pair<Integer, Integer> gridColsRows = config2.gridSizeOrNull();
                object = gridColsRows;
                if (object == null) break block5;
                Pair<Integer, Integer> pair2 = object;
                boolean bl2 = false;
                int ncols = ((Number)pair2.component1()).intValue();
                int nrows = ((Number)pair2.component2()).intValue();
                DoubleVector doubleVector = $this$compositeFigureSize_u24lambda_u241.defaultPlotGridSize(ncols, nrows);
                object = doubleVector;
                if (doubleVector != null) break block4;
            }
            object = Defaults.INSTANCE.getDEF_PLOT_SIZE();
        }
        Pair<Integer, Integer> figureSize = object;
        return this.toScaledSize((DoubleVector)figureSize, plotMaxWidth, plotPreferredWidth);
    }

    private final DoubleVector toScaledSize(DoubleVector size2, Double plotMaxWidth, Double plotPreferredWidth) {
        Object object;
        Object scaledSize;
        block6: {
            Object object2;
            block5: {
                object2 = plotPreferredWidth;
                if (object2 == null) break block5;
                double w = ((Number)object2).doubleValue();
                boolean bl = false;
                DoubleVector doubleVector = size2.mul(Math.max(50.0, w) / size2.getX());
                object2 = doubleVector;
                if (doubleVector != null) break block6;
            }
            object2 = scaledSize = size2;
        }
        if (plotMaxWidth != null && plotMaxWidth < ((DoubleVector)scaledSize).getX()) {
            double d = plotMaxWidth;
            object = ((DoubleVector)scaledSize).mul(Math.max(50.0, d) / ((DoubleVector)scaledSize).getX());
        } else {
            object = scaledSize;
        }
        return object;
    }

    private final List<DoubleRectangle> bunchItemBoundsList(Map<String, ? extends Object> bunchSpec) {
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            throw new IllegalArgumentException("No plots in the bunch");
        }
        ArrayList<DoubleRectangle> plotBounds = new ArrayList<DoubleRectangle>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            plotBounds.add(new DoubleRectangle(new DoubleVector(bunchItem.getX(), bunchItem.getY()), this.bunchItemSize$plot_config_portable(bunchItem)));
        }
        return plotBounds;
    }

    @NotNull
    public final DoubleVector bunchItemSize$plot_config_portable(@NotNull BunchConfig.BunchItem bunchItem) {
        Intrinsics.checkNotNullParameter((Object)bunchItem, (String)"bunchItem");
        return bunchItem.hasSize() ? bunchItem.getSize() : this.singlePlotSize(bunchItem.getFeatureSpec(), null, null, null, PlotFacets.Companion.undefined(), false);
    }

    private final DoubleVector defaultSinglePlotSize(PlotFacets facets, boolean containsLiveMap) {
        return facets.isDefined() ? this.defaulPlotPanelGridSize(facets.getColCount(), facets.getRowCount()) : (containsLiveMap ? Defaults.INSTANCE.getDEF_LIVE_MAP_SIZE() : Defaults.INSTANCE.getDEF_PLOT_SIZE());
    }

    private final DoubleVector defaultPlotGridSize(int ncol, int nrow) {
        return this.defaulPlotPanelGridSize(ncol, nrow);
    }

    private final DoubleVector defaulPlotPanelGridSize(int ncol, int nrow) {
        double panelWidth = Defaults.INSTANCE.getDEF_PLOT_SIZE().getX() * (0.5 + 0.5 / (double)ncol);
        double panelHeight = Defaults.INSTANCE.getDEF_PLOT_SIZE().getY() * (0.5 + 0.5 / (double)nrow);
        return new DoubleVector(panelWidth * (double)ncol, panelHeight * (double)nrow);
    }

    private final DoubleVector getSizeOptionOrNull(Map<?, ?> singlePlotSpec) {
        if (!singlePlotSpec.containsKey("ggsize")) {
            return null;
        }
        Intrinsics.checkNotNull(singlePlotSpec, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map<String, Object> map2 = new OptionsAccessor(singlePlotSpec, null, 2, null).getMap("ggsize");
        OptionsAccessor sizeSpec = OptionsAccessor.Companion.over(map2);
        Double width2 = sizeSpec.getDouble("width");
        Double height = sizeSpec.getDouble("height");
        if (width2 == null || height == null) {
            return null;
        }
        return new DoubleVector(width2, height);
    }

    public final double figureAspectRatio(@NotNull Map<?, ?> figureFpec) {
        double d;
        Intrinsics.checkNotNullParameter(figureFpec, (String)"figureFpec");
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figureFpec).ordinal()]) {
            case 2: 
            case 3: {
                DoubleVector doubleVector = this.getSizeOptionOrNull(figureFpec);
                if (doubleVector != null) {
                    DoubleVector it = doubleVector;
                    boolean bl = false;
                    d = it.getX() / it.getY();
                    break;
                }
                d = 1.5;
                break;
            }
            case 1: {
                DoubleVector bunchSize = this.plotBunchSize(figureFpec);
                d = bunchSize.getX() / bunchSize.getY();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @NotNull
    public final DoubleVector plotBunchSize(@NotNull Map<String, ? extends Object> plotBunchFpec) {
        Intrinsics.checkNotNullParameter(plotBunchFpec, (String)"plotBunchFpec");
        if (!(PlotConfig.Companion.figSpecKind(plotBunchFpec) == FigKind.GG_BUNCH_SPEC)) {
            boolean bl = false;
            String string = "Plot Bunch is expected but was kind: " + (Object)((Object)PlotConfig.Companion.figSpecKind(plotBunchFpec));
            throw new IllegalArgumentException(string.toString());
        }
        return this.plotBunchSize((Iterable<DoubleRectangle>)this.bunchItemBoundsList(plotBunchFpec));
    }

    /*
     * WARNING - void declaration
     */
    private final DoubleVector plotBunchSize(Iterable<DoubleRectangle> bunchItemBoundsIterable) {
        void $this$fold$iv;
        Iterable<DoubleRectangle> iterable = bunchItemBoundsIterable;
        DoubleRectangle initial$iv = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bounds;
            DoubleRectangle doubleRectangle = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.union((DoubleRectangle)bounds);
        }
        return accumulator$iv.getDimension();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

