/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.DisposableJPanel;
import jetbrains.datalore.plot.FigureToAwt;
import jetbrains.datalore.plot.MonolithicAwt;
import jetbrains.datalore.plot.MonolithicAwtKt;
import jetbrains.datalore.plot.MonolithicCommon;
import jetbrains.datalore.plot.builder.FigureBuildInfo;
import jetbrains.datalore.plot.config.FailureHandler;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\tH\u0002J\u008a\u0001\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\t2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0006\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\u0010\u001aJ\u008a\u0001\u0010\u001b\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\t2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0006\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0014\u0010\u001e\u001a\u00020\u00042\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/MonolithicAwt;", "", "()V", "buildGGBunchComponent", "Ljavax/swing/JComponent;", "plotInfos", "", "Ljetbrains/datalore/plot/builder/FigureBuildInfo;", "svgComponentFactory", "Lkotlin/Function1;", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "executor", "Lkotlin/Function0;", "", "buildPlotFromProcessedSpecs", "plotSpec", "", "", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plotMaxWidth", "", "computationMessagesHandler", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljavax/swing/JComponent;", "buildPlotFromRawSpecs", "createErrorLabel", "s", "handleException", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "plot-config"})
public final class MonolithicAwt {
    @NotNull
    public static final MonolithicAwt INSTANCE = new MonolithicAwt();

    private MonolithicAwt() {
    }

    @NotNull
    public final JComponent buildPlotFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            Map<String, Object> plotSpec2 = MonolithicCommon.INSTANCE.processRawSpecs(plotSpec, false);
            jComponent = this.buildPlotFromProcessedSpecs(plotSpec2, plotSize2, plotMaxWidth, svgComponentFactory, executor, computationMessagesHandler);
        }
        catch (RuntimeException e) {
            jComponent = this.handleException(e);
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent buildPlotFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            JComponent jComponent;
            void $this$flatMapTo$iv$iv;
            MonolithicCommon.PlotsBuildResult buildResult = MonolithicCommon.INSTANCE.buildPlotsFromProcessedSpecs(plotSpec, plotSize2, plotMaxWidth, null);
            if (buildResult.isError()) {
                Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Error");
                String errorMessage = ((MonolithicCommon.PlotsBuildResult.Error)buildResult).getError();
                return this.createErrorLabel(errorMessage);
            }
            Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Success");
            MonolithicCommon.PlotsBuildResult.Success success2 = (MonolithicCommon.PlotsBuildResult.Success)buildResult;
            Iterable $this$flatMap$iv = success2.getBuildInfos();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                FigureBuildInfo it = (FigureBuildInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getComputationMessages();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List computationMessages = (List)destination$iv$iv;
            computationMessagesHandler.invoke((Object)computationMessages);
            if (success2.getBuildInfos().size() == 1) {
                FigureBuildInfo buildInfo = success2.getBuildInfos().get(0);
                jComponent = new FigureToAwt(buildInfo, svgComponentFactory, executor).eval();
            } else {
                jComponent = this.buildGGBunchComponent(success2.getBuildInfos(), svgComponentFactory, executor);
            }
            return jComponent;
        }
        catch (RuntimeException e) {
            return this.handleException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildGGBunchComponent(List<? extends FigureBuildInfo> plotInfos, Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, Function1<? super Function0<Unit>, Unit> executor) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Object bounds;
        DisposableJPanel bunchComponent = new DisposableJPanel(null);
        bunchComponent.setBorder(null);
        bunchComponent.setOpaque(false);
        for (FigureBuildInfo figureBuildInfo : plotInfos) {
            JComponent itemComp = new FigureToAwt(figureBuildInfo, svgComponentFactory, executor).eval();
            bounds = figureBuildInfo.getBounds();
            itemComp.setBounds(new Rectangle((int)((DoubleRectangle)bounds).getOrigin().getX(), (int)((DoubleRectangle)bounds).getOrigin().getY(), (int)((DoubleRectangle)bounds).getDimension().getX(), (int)((DoubleRectangle)bounds).getDimension().getY()));
            bunchComponent.add(itemComp);
        }
        Iterable iterable = plotInfos;
        boolean $i$f$map = false;
        bounds = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FigureBuildInfo figureBuildInfo = (FigureBuildInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            bl = false;
            collection.add(it.getBounds());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        DoubleRectangle initial$iv = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : iterable2) {
            void bounds2;
            Object item$iv$iv;
            item$iv$iv = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            bl = false;
            accumulator$iv = acc.union((DoubleRectangle)bounds2);
        }
        DoubleRectangle bunchBounds = accumulator$iv;
        Dimension dimension = new Dimension((int)bunchBounds.getWidth(), (int)bunchBounds.getHeight());
        bunchComponent.setPreferredSize(dimension);
        bunchComponent.setMinimumSize(dimension);
        bunchComponent.setMaximumSize(dimension);
        return bunchComponent;
    }

    private final JComponent handleException(RuntimeException e) {
        FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
        if (failureInfo.isInternalError()) {
            MonolithicAwtKt.access$get_aLOG$p().error((Throwable)e, (Function0)handleException.1.INSTANCE);
        }
        return this.createErrorLabel(failureInfo.getMessage());
    }

    private final JComponent createErrorLabel(String s2) {
        JLabel label = new JLabel(s2);
        label.setForeground(Color.RED);
        return label;
    }
}

