/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.event;

import java.util.ArrayList;
import java.util.Arrays;
import jetbrains.datalore.base.observable.collections.CollectionAdapter;
import jetbrains.datalore.base.observable.collections.CollectionItemEvent;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.base.observable.event.CompositeEventSource;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.event.EventSource;
import jetbrains.datalore.base.observable.event.MappingEventSource;
import jetbrains.datalore.base.registration.Registration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u001e\u0010\u0006\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\u0007\"\b\u0012\u0004\u0012\u0002H\u00050\u0004\u00a2\u0006\u0002\u0010\bJ&\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\tJ\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005JB\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042 \u0010\r\u001a\u001c\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000f0\u000ej\n\u0012\u0006\b\u0000\u0012\u0002H\u0005`\u0010J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00120\u000eJ+\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0007\"\u0002H\u0005\u00a2\u0006\u0002\u0010\u0018JB\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u001a\u0010\u001d\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\u000e\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/base/observable/event/EventSources;", "", "()V", "composite", "Ljetbrains/datalore/base/observable/event/EventSource;", "EventT", "sources", "", "([Ljetbrains/datalore/base/observable/event/EventSource;)Ljetbrains/datalore/base/observable/event/EventSource;", "", "empty", "filter", "source", "pred", "Lkotlin/Function1;", "", "Ljetbrains/datalore/base/function/Predicate;", "map", "TargetEventT", "SourceEventT", "src", "f", "of", "events", "([Ljava/lang/Object;)Ljetbrains/datalore/base/observable/event/EventSource;", "selectList", "ItemT", "list", "Ljetbrains/datalore/base/observable/collections/list/ObservableList;", "selector", "base-portable"})
public final class EventSources {
    @NotNull
    public static final EventSources INSTANCE = new EventSources();

    private EventSources() {
    }

    @NotNull
    public final <EventT> EventSource<EventT> of(EventT ... events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        return new EventSource<EventT>(events){
            final /* synthetic */ EventT[] $events;
            {
                this.$events = $events;
            }

            @NotNull
            public Registration addHandler(@NotNull EventHandler<? super EventT> handler2) {
                Intrinsics.checkNotNullParameter(handler2, (String)"handler");
                for (EventT e : this.$events) {
                    handler2.onEvent(e);
                }
                return Registration.Companion.getEMPTY();
            }
        };
    }

    @NotNull
    public final <EventT> EventSource<EventT> empty() {
        return this.composite(new EventSource[0]);
    }

    @NotNull
    public final <EventT> EventSource<EventT> composite(EventSource<EventT> ... sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        return new CompositeEventSource<EventT>(Arrays.copyOf(sources, sources.length));
    }

    @NotNull
    public final <EventT> EventSource<EventT> composite(@NotNull Iterable<? extends EventSource<EventT>> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        return new CompositeEventSource(sources);
    }

    @NotNull
    public final <EventT> EventSource<EventT> filter(@NotNull EventSource<EventT> source, @NotNull Function1<? super EventT, Boolean> pred) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        return new EventSource<EventT>(source, pred){
            final /* synthetic */ EventSource<EventT> $source;
            final /* synthetic */ Function1<EventT, Boolean> $pred;
            {
                this.$source = $source;
                this.$pred = $pred;
            }

            @NotNull
            public Registration addHandler(@NotNull EventHandler<? super EventT> handler2) {
                Intrinsics.checkNotNullParameter(handler2, (String)"handler");
                return this.$source.addHandler(new EventHandler<EventT>(this.$pred, handler2){
                    final /* synthetic */ Function1<EventT, Boolean> $pred;
                    final /* synthetic */ EventHandler<EventT> $handler;
                    {
                        this.$pred = $pred;
                        this.$handler = $handler;
                    }

                    public void onEvent(EventT event) {
                        if (((Boolean)this.$pred.invoke(event)).booleanValue()) {
                            this.$handler.onEvent(event);
                        }
                    }
                });
            }
        };
    }

    @NotNull
    public final <SourceEventT, TargetEventT> EventSource<TargetEventT> map(@NotNull EventSource<SourceEventT> src, @NotNull Function1<? super SourceEventT, ? extends TargetEventT> f) {
        Intrinsics.checkNotNullParameter(src, (String)"src");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new MappingEventSource<SourceEventT, TargetEventT>(src, f);
    }

    @NotNull
    public final <EventT, ItemT> EventSource<EventT> selectList(@NotNull ObservableList<ItemT> list2, @NotNull Function1<? super ItemT, ? extends EventSource<EventT>> selector) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return new EventSource<EventT>(list2, selector){
            final /* synthetic */ ObservableList<ItemT> $list;
            final /* synthetic */ Function1<ItemT, EventSource<EventT>> $selector;
            {
                this.$list = $list;
                this.$selector = $selector;
            }

            @NotNull
            public Registration addHandler(@NotNull EventHandler<? super EventT> handler2) {
                Intrinsics.checkNotNullParameter(handler2, (String)"handler");
                ArrayList<Registration> itemRegs = new ArrayList<Registration>();
                for (E item : this.$list) {
                    itemRegs.add(((EventSource)this.$selector.invoke(item)).addHandler(handler2));
                }
                Registration listReg2 = this.$list.addListener(new CollectionAdapter<ItemT>(itemRegs, this.$selector, handler2){
                    final /* synthetic */ ArrayList<Registration> $itemRegs;
                    final /* synthetic */ Function1<ItemT, EventSource<EventT>> $selector;
                    final /* synthetic */ EventHandler<EventT> $handler;
                    {
                        this.$itemRegs = $itemRegs;
                        this.$selector = $selector;
                        this.$handler = $handler;
                    }

                    public void onItemAdded(@NotNull CollectionItemEvent<? extends ItemT> event) {
                        Intrinsics.checkNotNullParameter(event, (String)"event");
                        this.$itemRegs.add(event.getIndex(), ((EventSource)this.$selector.invoke(event.getNewItem())).addHandler(this.$handler));
                    }

                    public void onItemRemoved(@NotNull CollectionItemEvent<? extends ItemT> event) {
                        Intrinsics.checkNotNullParameter(event, (String)"event");
                        this.$itemRegs.remove(event.getIndex()).remove();
                    }
                });
                return new Registration(itemRegs, listReg2){
                    final /* synthetic */ ArrayList<Registration> $itemRegs;
                    final /* synthetic */ Registration $listReg;
                    {
                        this.$itemRegs = $itemRegs;
                        this.$listReg = $listReg;
                    }

                    protected void doRemove() {
                        for (Registration r : this.$itemRegs) {
                            r.remove();
                        }
                        this.$listReg.remove();
                    }
                };
            }
        };
    }
}

