/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.collections.list;

import jetbrains.datalore.base.observable.collections.DataloreIndexOutOfBoundsException;
import jetbrains.datalore.base.observable.collections.list.AbstractObservableList;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u001d\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u001dR$\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/base/observable/collections/list/ObservableSingleItemList;", "ItemT", "Ljetbrains/datalore/base/observable/collections/list/AbstractObservableList;", "()V", "item", "(Ljava/lang/Object;)V", "getItem", "()Ljava/lang/Object;", "setItem", "myEmpty", "", "myItem", "Ljava/lang/Object;", "size", "", "getSize", "()I", "checkAdd", "", "index", "(ILjava/lang/Object;)V", "checkSet", "oldItem", "newItem", "(ILjava/lang/Object;Ljava/lang/Object;)V", "doAdd", "doRemove", "doSet", "get", "(I)Ljava/lang/Object;", "base"})
public final class ObservableSingleItemList<ItemT>
extends AbstractObservableList<ItemT> {
    @Nullable
    private ItemT myItem;
    private boolean myEmpty = true;

    public final ItemT getItem() {
        return this.get(0);
    }

    public final void setItem(ItemT item) {
        if (this.myEmpty) {
            this.add(item);
        } else {
            this.set(0, item);
        }
    }

    public ObservableSingleItemList() {
    }

    public ObservableSingleItemList(ItemT item) {
        this.myItem = item;
        this.myEmpty = false;
    }

    public int getSize() {
        return this.myEmpty ? 0 : 1;
    }

    @Override
    public ItemT get(int index) {
        if (this.myEmpty || index != 0) {
            throw new DataloreIndexOutOfBoundsException(index);
        }
        return this.myItem;
    }

    @Override
    protected void checkAdd(int index, ItemT item) {
        super.checkAdd(index, item);
        if (!this.myEmpty) {
            throw new IllegalStateException("Single item list already has an item");
        }
    }

    @Override
    protected void checkSet(int index, ItemT oldItem, ItemT newItem) {
        this.checkRemove(index, oldItem);
    }

    @Override
    protected void doAdd(int index, ItemT item) {
        this.myItem = item;
        this.myEmpty = false;
    }

    @Override
    protected void doSet(int index, ItemT item) {
        this.myItem = item;
    }

    @Override
    protected void doRemove(int index) {
        this.myItem = null;
        this.myEmpty = true;
    }
}

