/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkITXT;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTextVar;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "isCompressed", "", "langtag", "", "translatedTag", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "Companion", "plot-api"})
public final class PngChunkITXT
extends PngChunkTextVar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isCompressed;
    @NotNull
    private String langtag = "";
    @NotNull
    private String translatedTag = "";
    @NotNull
    public static final String ID = "iTXt";

    public PngChunkITXT(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        block8: {
            block7: {
                if (this.getKey() == null) break block7;
                String string = this.getKey();
                Intrinsics.checkNotNull((Object)string);
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block8;
            }
            throw new PngjException("Text chunk key must be non empty");
        }
        OutputPngStream ba = new OutputPngStream();
        String string = this.getKey();
        Intrinsics.checkNotNull((Object)string);
        ba.write(ChunkHelper.INSTANCE.toBytesLatin1(string));
        ba.write(0);
        ba.write(this.isCompressed ? 1 : 0);
        ba.write(0);
        ba.write(ChunkHelper.INSTANCE.toBytesLatin1(this.langtag));
        ba.write(0);
        ba.write(ChunkHelper.INSTANCE.toBytesUTF8(this.translatedTag));
        ba.write(0);
        String string2 = this.getValue();
        Intrinsics.checkNotNull((Object)string2);
        byte[] textbytes = ChunkHelper.INSTANCE.toBytesUTF8(string2);
        if (this.isCompressed) {
            textbytes = ChunkHelper.INSTANCE.compressBytes(textbytes, true);
        }
        ba.write(textbytes);
        byte[] b = ba.getByteArray();
        ChunkRaw chunk = this.createEmptyChunk(b.length, false);
        chunk.setData(b);
        return chunk;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        int nullsFound = 0;
        int[] nullsIdx = new int[3];
        PngChunkITXT $this$parseFromRaw_u24lambda_u241 = this;
        boolean bl = false;
        int i = 0;
        while (true) {
            byte[] byArray = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray);
            if (i >= byArray.length) break;
            byte[] byArray2 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray2);
            if (byArray2[i] != 0) {
                ++i;
                continue;
            }
            nullsIdx[nullsFound] = i;
            if (++nullsFound == 1) {
                i += 2;
            }
            if (nullsFound == 3) break;
            ++i;
        }
        if (nullsFound != 3) {
            throw new PngjException("Bad formed PngChunkITXT chunk");
        }
        byte[] byArray = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray);
        this.setKey(ChunkHelper.INSTANCE.toStringLatin1(byArray, 0, nullsIdx[0]));
        int i2 = nullsIdx[0] + 1;
        byte[] byArray3 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray3);
        this.isCompressed = byArray3[i2] != 0;
        ++i2;
        if (this.isCompressed) {
            byte[] byArray4 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray4);
            if (byArray4[i2] != 0) {
                throw new PngjException("Bad formed PngChunkITXT chunk - bad compression method ");
            }
        }
        byte[] byArray5 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray5);
        this.langtag = ChunkHelper.INSTANCE.toStringLatin1(byArray5, i2, nullsIdx[1] - i2);
        byte[] byArray6 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray6);
        this.translatedTag = ChunkHelper.INSTANCE.toStringUTF8(byArray6, nullsIdx[1] + 1, nullsIdx[2] - nullsIdx[1] - 1);
        i2 = nullsIdx[2] + 1;
        if (this.isCompressed) {
            byte[] byArray7 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray7);
            byte[] byArray8 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray8);
            byte[] bytes = ChunkHelper.INSTANCE.compressBytes(byArray7, i2, byArray8.length - i2, false);
            string = ChunkHelper.INSTANCE.toStringUTF8(bytes);
        } else {
            byte[] byArray9 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray9);
            byte[] byArray10 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray10);
            string = ChunkHelper.INSTANCE.toStringUTF8(byArray9, i2, byArray10.length - i2);
        }
        this.setValue(string);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkITXT$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

